/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.export;

import com.google.common.eventbus.EventBus;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.graylog.plugins.views.search.events.MessagesExportEvent;
import org.graylog.plugins.views.search.export.AuditContext;
import org.graylog.plugins.views.search.export.ExportMessagesCommand;
import org.graylog.plugins.views.search.export.MessagesExporter;
import org.graylog.plugins.views.search.export.SimpleMessageChunk;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class AuditingMessagesExporter
implements MessagesExporter {
    private final AuditContext context;
    private final EventBus eventBus;
    private final MessagesExporter decoratedExporter;
    public Supplier<DateTime> startedAt = () -> DateTime.now((DateTimeZone)DateTimeZone.UTC);
    public Supplier<DateTime> finishedAt = () -> DateTime.now((DateTimeZone)DateTimeZone.UTC);

    public AuditingMessagesExporter(AuditContext context, EventBus eventBus, MessagesExporter decoratedExporter) {
        this.context = context;
        this.eventBus = eventBus;
        this.decoratedExporter = decoratedExporter;
    }

    @Override
    public void export(ExportMessagesCommand command, Consumer<SimpleMessageChunk> chunkForwarder) {
        this.post(MessagesExportEvent.requested(this.startedAt.get(), this.context, command));
        this.decoratedExporter.export(command, chunkForwarder);
        this.post(MessagesExportEvent.succeeded(this.finishedAt.get(), this.context, command));
    }

    private void post(Object event) {
        this.eventBus.post(Objects.requireNonNull(event));
    }
}

