/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.export;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Positive;
import org.graylog.plugins.views.search.export.AutoValue_ResultFormat;
import org.graylog.plugins.views.search.export.ExportMessagesCommand;
import org.graylog.plugins.views.search.export.LinkedHashSetUtil;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;

@JsonAutoDetect
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class ResultFormat {
    private static final String FIELD_FIELDS = "fields_in_order";

    @JsonProperty(value="fields_in_order")
    @NotEmpty
    public abstract LinkedHashSet<String> fieldsInOrder();

    @JsonProperty
    public abstract Optional<AbsoluteRange> timerange();

    @JsonProperty
    public abstract Optional<Integer> limit();

    @JsonProperty
    public abstract Map<String, Object> executionState();

    @JsonProperty
    public abstract Optional<String> filename();

    public static Builder builder() {
        return Builder.create();
    }

    public static ResultFormat empty() {
        return ResultFormat.builder().build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonProperty(value="fields_in_order")
        public abstract Builder fieldsInOrder(LinkedHashSet<String> var1);

        public Builder fieldsInOrder(String ... fields) {
            return this.fieldsInOrder(LinkedHashSetUtil.linkedHashSetOf(fields));
        }

        @JsonProperty
        public abstract Builder limit(@Positive @Nullable Integer var1);

        @JsonProperty
        public abstract Builder executionState(Map<String, Object> var1);

        @JsonProperty
        public abstract Builder timerange(@Nullable AbsoluteRange var1);

        @JsonProperty
        public abstract Builder filename(@Nullable String var1);

        public abstract ResultFormat build();

        @JsonCreator
        public static Builder create() {
            return new AutoValue_ResultFormat.Builder().fieldsInOrder(ExportMessagesCommand.DEFAULT_FIELDS).executionState(Collections.emptyMap());
        }
    }
}

