/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import org.graylog2.database.NotFoundException;
import org.graylog2.inputs.Input;
import org.graylog2.inputs.InputService;
import org.graylog2.plugin.IOState;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.rest.models.system.inputs.responses.InputCreated;
import org.graylog2.rest.models.system.inputs.responses.InputDeleted;
import org.graylog2.rest.models.system.inputs.responses.InputUpdated;
import org.graylog2.shared.inputs.InputLauncher;
import org.graylog2.shared.inputs.InputRegistry;
import org.graylog2.shared.inputs.NoSuchInputTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(InputEventListener.class);
    private final InputLauncher inputLauncher;
    private final InputRegistry inputRegistry;
    private final InputService inputService;
    private final NodeId nodeId;

    @Inject
    public InputEventListener(EventBus eventBus, InputLauncher inputLauncher, InputRegistry inputRegistry, InputService inputService, NodeId nodeId) {
        this.inputLauncher = inputLauncher;
        this.inputRegistry = inputRegistry;
        this.inputService = inputService;
        this.nodeId = nodeId;
        eventBus.register((Object)this);
    }

    @Subscribe
    public void inputCreated(InputCreated inputCreatedEvent) {
        Input input;
        String inputId = inputCreatedEvent.id();
        LOG.debug("Input created: {}", (Object)inputId);
        try {
            input = this.inputService.find(inputId);
        }
        catch (NotFoundException e) {
            LOG.warn("Received InputCreated event but could not find input {}", (Object)inputId, (Object)e);
            return;
        }
        IOState<MessageInput> inputState = this.inputRegistry.getInputState(inputId);
        if (inputState != null) {
            this.inputRegistry.remove(inputState);
        }
        if (input.isGlobal().booleanValue() || this.nodeId.toString().equals(input.getNodeId())) {
            this.startInput(input);
        }
    }

    @Subscribe
    public void inputUpdated(InputUpdated inputUpdatedEvent) {
        boolean startInput;
        Input input;
        String inputId = inputUpdatedEvent.id();
        LOG.debug("Input updated: {}", (Object)inputId);
        try {
            input = this.inputService.find(inputId);
        }
        catch (NotFoundException e) {
            LOG.warn("Received InputUpdated event but could not find input {}", (Object)inputId, (Object)e);
            return;
        }
        IOState<MessageInput> inputState = this.inputRegistry.getInputState(inputId);
        if (inputState != null) {
            startInput = inputState.getState() == IOState.Type.RUNNING;
            this.inputRegistry.remove(inputState);
        } else {
            startInput = false;
        }
        if (startInput && (input.isGlobal().booleanValue() || this.nodeId.toString().equals(input.getNodeId()))) {
            this.startInput(input);
        }
    }

    private void startInput(Input input) {
        MessageInput messageInput;
        try {
            messageInput = this.inputService.getMessageInput(input);
        }
        catch (NoSuchInputTypeException e) {
            LOG.warn("Input {} ({}) is of invalid type {}", new Object[]{input.getTitle(), input.getId(), input.getType(), e});
            return;
        }
        messageInput.initialize();
        IOState<MessageInput> newInputState = this.inputLauncher.launch(messageInput);
        this.inputRegistry.add(newInputState);
    }

    @Subscribe
    public void inputDeleted(InputDeleted inputDeletedEvent) {
        LOG.debug("Input deleted: {}", (Object)inputDeletedEvent.id());
        IOState<MessageInput> inputState = this.inputRegistry.getInputState(inputDeletedEvent.id());
        if (inputState != null) {
            this.inputRegistry.remove(inputState);
        }
    }
}

