/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.syslog.tcp;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.util.ReferenceCountUtil;
import org.graylog2.inputs.syslog.tcp.SyslogOctetCountFrameDecoder;

public class SyslogTCPFramingRouterHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private final int maxFrameLength;
    private final ByteBuf[] delimiter;
    private ChannelInboundHandler handler = null;

    public SyslogTCPFramingRouterHandler(int maxFrameLength, ByteBuf[] delimiter) {
        this.maxFrameLength = maxFrameLength;
        this.delimiter = delimiter;
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        if (msg.isReadable()) {
            if (this.handler == null) {
                this.handler = this.usesOctetCountFraming(msg) ? new SyslogOctetCountFrameDecoder() : new DelimiterBasedFrameDecoder(this.maxFrameLength, this.delimiter);
            }
            this.handler.channelRead(ctx, ReferenceCountUtil.retain((Object)msg));
        } else {
            ctx.fireChannelRead((Object)msg);
        }
    }

    private boolean usesOctetCountFraming(ByteBuf message) {
        byte firstByte = message.getByte(0);
        return 48 < firstByte && firstByte <= 57;
    }
}

