/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.RatioGauge;
import com.github.joschi.jadconfig.util.Size;
import com.google.common.eventbus.EventBus;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.GlobalMetricNames;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.ThrottleState;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.shared.buffers.ProcessBuffer;
import org.graylog2.shared.journal.Journal;
import org.graylog2.shared.journal.LocalKafkaJournal;
import org.graylog2.shared.metrics.MetricUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottleStateUpdaterThread
extends Periodical {
    private static final Logger log = LoggerFactory.getLogger(ThrottleStateUpdaterThread.class);
    private final LocalKafkaJournal journal;
    private final ProcessBuffer processBuffer;
    private final EventBus eventBus;
    private final Size retentionSize;
    private final NotificationService notificationService;
    private final ServerStatus serverStatus;
    private boolean firstRun = true;
    private long logEndOffset;
    private long currentReadOffset;
    private long currentTs;
    private ThrottleState throttleState;

    @Inject
    public ThrottleStateUpdaterThread(Journal journal, ProcessBuffer processBuffer, EventBus eventBus, NotificationService notificationService, ServerStatus serverStatus, MetricRegistry metricRegistry, @Named(value="message_journal_max_size") Size retentionSize) {
        this.processBuffer = processBuffer;
        this.eventBus = eventBus;
        this.retentionSize = retentionSize;
        this.notificationService = notificationService;
        this.serverStatus = serverStatus;
        this.journal = journal instanceof LocalKafkaJournal ? (LocalKafkaJournal)journal : null;
        this.throttleState = new ThrottleState();
        MetricUtils.safelyRegister(metricRegistry, GlobalMetricNames.JOURNAL_APPEND_RATE, new Gauge<Long>(){

            public Long getValue() {
                return ((ThrottleStateUpdaterThread)ThrottleStateUpdaterThread.this).throttleState.appendEventsPerSec;
            }
        });
        MetricUtils.safelyRegister(metricRegistry, GlobalMetricNames.JOURNAL_READ_RATE, new Gauge<Long>(){

            public Long getValue() {
                return ((ThrottleStateUpdaterThread)ThrottleStateUpdaterThread.this).throttleState.readEventsPerSec;
            }
        });
        MetricUtils.safelyRegister(metricRegistry, "org.graylog2.journal.segments", new Gauge<Integer>(){

            public Integer getValue() {
                if (ThrottleStateUpdaterThread.this.journal == null) {
                    return 0;
                }
                return ThrottleStateUpdaterThread.this.journal.numberOfSegments();
            }
        });
        MetricUtils.safelyRegister(metricRegistry, "org.graylog2.journal.entries-uncommitted", new Gauge<Long>(){

            public Long getValue() {
                return ((ThrottleStateUpdaterThread)ThrottleStateUpdaterThread.this).throttleState.uncommittedJournalEntries;
            }
        });
        final Gauge sizeGauge = MetricUtils.safelyRegister(metricRegistry, "org.graylog2.journal.size", new Gauge<Long>(){

            public Long getValue() {
                return ((ThrottleStateUpdaterThread)ThrottleStateUpdaterThread.this).throttleState.journalSize;
            }
        });
        final Gauge sizeLimitGauge = MetricUtils.safelyRegister(metricRegistry, "org.graylog2.journal.size-limit", new Gauge<Long>(){

            public Long getValue() {
                return ((ThrottleStateUpdaterThread)ThrottleStateUpdaterThread.this).throttleState.journalSizeLimit;
            }
        });
        MetricUtils.safelyRegister(metricRegistry, "org.graylog2.journal.utilization-ratio", new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)((Long)sizeGauge.getValue()).longValue(), (double)((Long)sizeLimitGauge.getValue()).longValue());
            }
        });
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return true;
    }

    @Override
    public boolean masterOnly() {
        return false;
    }

    @Override
    public boolean startOnThisNode() {
        return this.journal != null;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 1;
    }

    @Override
    public int getPeriodSeconds() {
        return 1;
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    @Override
    public void doRun() {
        Notification notification;
        double journalUtilizationPercentage;
        this.throttleState = new ThrottleState(this.throttleState);
        long committedOffset = this.journal.getCommittedOffset();
        long prevTs = this.currentTs;
        this.currentTs = System.nanoTime();
        long previousLogEndOffset = this.logEndOffset;
        long previousReadOffset = this.currentReadOffset;
        long logStartOffset = this.journal.getLogStartOffset();
        this.logEndOffset = this.journal.getLogEndOffset() - 1L;
        this.currentReadOffset = this.journal.getNextReadOffset() - 1L;
        if (this.firstRun) {
            this.firstRun = false;
            return;
        }
        this.throttleState.appendEventsPerSec = (long)Math.floor((double)(this.logEndOffset - previousLogEndOffset) / ((double)(this.currentTs - prevTs) / 1.0E9));
        this.throttleState.readEventsPerSec = (long)Math.floor((double)(this.currentReadOffset - previousReadOffset) / ((double)(this.currentTs - prevTs) / 1.0E9));
        this.throttleState.journalSize = this.journal.size();
        this.throttleState.journalSizeLimit = this.retentionSize.toBytes();
        this.throttleState.processBufferCapacity = this.processBuffer.getRemainingCapacity();
        this.throttleState.uncommittedJournalEntries = committedOffset == Long.MIN_VALUE ? (this.journal.size() == 0L ? 0L : this.logEndOffset - logStartOffset) : this.logEndOffset - committedOffset;
        log.debug("ThrottleState: {}", (Object)this.throttleState);
        this.journal.setThrottleState(this.throttleState);
        this.eventBus.post((Object)this.throttleState);
        double d = journalUtilizationPercentage = this.throttleState.journalSizeLimit > 0L ? (double)(this.throttleState.journalSize * 100L / this.throttleState.journalSizeLimit) : 0.0;
        if (journalUtilizationPercentage > 95.0) {
            notification = this.notificationService.buildNow().addNode(this.serverStatus.getNodeId().toString()).addType(Notification.Type.JOURNAL_UTILIZATION_TOO_HIGH).addSeverity(Notification.Severity.URGENT).addDetail("journal_utilization_percentage", journalUtilizationPercentage);
            this.notificationService.publishIfFirst(notification);
        }
        if (this.journal.getPurgedSegmentsInLastRetention() > 0) {
            notification = this.notificationService.buildNow().addNode(this.serverStatus.getNodeId().toString()).addType(Notification.Type.JOURNAL_UNCOMMITTED_MESSAGES_DELETED).addSeverity(Notification.Severity.URGENT);
            this.notificationService.publishIfFirst(notification);
        }
    }
}

