/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.contentpack.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog.events.contentpack.entities.AggregationEventProcessorConfigEntity;
import org.graylog.events.processor.aggregation.AggregationConditions;
import org.graylog.events.processor.aggregation.AggregationSeries;
import org.graylog2.contentpacks.model.entities.references.ValueReference;

final class AutoValue_AggregationEventProcessorConfigEntity
extends AggregationEventProcessorConfigEntity {
    private final String type;
    private final ValueReference query;
    private final ImmutableSet<String> streams;
    private final List<String> groupBy;
    private final List<AggregationSeries> series;
    private final Optional<AggregationConditions> conditions;
    private final long searchWithinMs;
    private final long executeEveryMs;

    private AutoValue_AggregationEventProcessorConfigEntity(String type, ValueReference query, ImmutableSet<String> streams, List<String> groupBy, List<AggregationSeries> series, Optional<AggregationConditions> conditions, long searchWithinMs, long executeEveryMs) {
        this.type = type;
        this.query = query;
        this.streams = streams;
        this.groupBy = groupBy;
        this.series = series;
        this.conditions = conditions;
        this.searchWithinMs = searchWithinMs;
        this.executeEveryMs = executeEveryMs;
    }

    @Override
    @JsonProperty(value="type")
    public String type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="query")
    public ValueReference query() {
        return this.query;
    }

    @Override
    @JsonProperty(value="streams")
    public ImmutableSet<String> streams() {
        return this.streams;
    }

    @Override
    @JsonProperty(value="group_by")
    public List<String> groupBy() {
        return this.groupBy;
    }

    @Override
    @JsonProperty(value="series")
    public List<AggregationSeries> series() {
        return this.series;
    }

    @Override
    @JsonProperty(value="conditions")
    public Optional<AggregationConditions> conditions() {
        return this.conditions;
    }

    @Override
    @JsonProperty(value="search_within_ms")
    public long searchWithinMs() {
        return this.searchWithinMs;
    }

    @Override
    @JsonProperty(value="execute_every_ms")
    public long executeEveryMs() {
        return this.executeEveryMs;
    }

    public String toString() {
        return "AggregationEventProcessorConfigEntity{type=" + this.type + ", query=" + this.query + ", streams=" + this.streams + ", groupBy=" + this.groupBy + ", series=" + this.series + ", conditions=" + this.conditions + ", searchWithinMs=" + this.searchWithinMs + ", executeEveryMs=" + this.executeEveryMs + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AggregationEventProcessorConfigEntity) {
            AggregationEventProcessorConfigEntity that = (AggregationEventProcessorConfigEntity)o;
            return this.type.equals(that.type()) && this.query.equals(that.query()) && this.streams.equals(that.streams()) && this.groupBy.equals(that.groupBy()) && this.series.equals(that.series()) && this.conditions.equals(that.conditions()) && this.searchWithinMs == that.searchWithinMs() && this.executeEveryMs == that.executeEveryMs();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.type.hashCode();
        h$ *= 1000003;
        h$ ^= this.query.hashCode();
        h$ *= 1000003;
        h$ ^= this.streams.hashCode();
        h$ *= 1000003;
        h$ ^= this.groupBy.hashCode();
        h$ *= 1000003;
        h$ ^= this.series.hashCode();
        h$ *= 1000003;
        h$ ^= this.conditions.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.searchWithinMs >>> 32 ^ this.searchWithinMs);
        h$ *= 1000003;
        return h$ ^= (int)(this.executeEveryMs >>> 32 ^ this.executeEveryMs);
    }

    @Override
    public AggregationEventProcessorConfigEntity.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends AggregationEventProcessorConfigEntity.Builder {
        private String type;
        private ValueReference query;
        private ImmutableSet<String> streams;
        private List<String> groupBy;
        private List<AggregationSeries> series;
        private Optional<AggregationConditions> conditions = Optional.empty();
        private Long searchWithinMs;
        private Long executeEveryMs;

        Builder() {
        }

        private Builder(AggregationEventProcessorConfigEntity source) {
            this.type = source.type();
            this.query = source.query();
            this.streams = source.streams();
            this.groupBy = source.groupBy();
            this.series = source.series();
            this.conditions = source.conditions();
            this.searchWithinMs = source.searchWithinMs();
            this.executeEveryMs = source.executeEveryMs();
        }

        @Override
        public AggregationEventProcessorConfigEntity.Builder type(String type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        public AggregationEventProcessorConfigEntity.Builder query(ValueReference query) {
            if (query == null) {
                throw new NullPointerException("Null query");
            }
            this.query = query;
            return this;
        }

        @Override
        public AggregationEventProcessorConfigEntity.Builder streams(ImmutableSet<String> streams) {
            if (streams == null) {
                throw new NullPointerException("Null streams");
            }
            this.streams = streams;
            return this;
        }

        @Override
        public AggregationEventProcessorConfigEntity.Builder groupBy(List<String> groupBy) {
            if (groupBy == null) {
                throw new NullPointerException("Null groupBy");
            }
            this.groupBy = groupBy;
            return this;
        }

        @Override
        public AggregationEventProcessorConfigEntity.Builder series(List<AggregationSeries> series) {
            if (series == null) {
                throw new NullPointerException("Null series");
            }
            this.series = series;
            return this;
        }

        @Override
        public AggregationEventProcessorConfigEntity.Builder conditions(@Nullable AggregationConditions conditions) {
            this.conditions = Optional.ofNullable(conditions);
            return this;
        }

        @Override
        public AggregationEventProcessorConfigEntity.Builder searchWithinMs(long searchWithinMs) {
            this.searchWithinMs = searchWithinMs;
            return this;
        }

        @Override
        public AggregationEventProcessorConfigEntity.Builder executeEveryMs(long executeEveryMs) {
            this.executeEveryMs = executeEveryMs;
            return this;
        }

        @Override
        public AggregationEventProcessorConfigEntity build() {
            String missing = "";
            if (this.type == null) {
                missing = missing + " type";
            }
            if (this.query == null) {
                missing = missing + " query";
            }
            if (this.streams == null) {
                missing = missing + " streams";
            }
            if (this.groupBy == null) {
                missing = missing + " groupBy";
            }
            if (this.series == null) {
                missing = missing + " series";
            }
            if (this.searchWithinMs == null) {
                missing = missing + " searchWithinMs";
            }
            if (this.executeEveryMs == null) {
                missing = missing + " executeEveryMs";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_AggregationEventProcessorConfigEntity(this.type, this.query, this.streams, this.groupBy, this.series, this.conditions, this.searchWithinMs, this.executeEveryMs);
        }
    }
}

