/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.event;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Optional;
import org.graylog.events.event.AutoValue_EventOriginContext_ESEventOriginContext;

public class EventOriginContext {
    private static final String URN = "urn:graylog";
    private static final String ES_MESSAGE = String.join((CharSequence)":", "urn:graylog", "message:es");
    private static final String ES_EVENT = String.join((CharSequence)":", "urn:graylog", "event:es");

    public static String elasticsearchMessage(String indexName, String messageId) {
        EventOriginContext.checkArgument("indexName", indexName);
        EventOriginContext.checkArgument("messageId", messageId);
        return String.join((CharSequence)":", ES_MESSAGE, indexName, messageId);
    }

    public static String elasticsearchEvent(String indexName, String eventId) {
        EventOriginContext.checkArgument("indexName", indexName);
        EventOriginContext.checkArgument("eventId", eventId);
        return String.join((CharSequence)":", ES_EVENT, indexName, eventId);
    }

    public static Optional<ESEventOriginContext> parseESContext(String url) {
        if (url.startsWith(ES_EVENT) || url.startsWith(ES_MESSAGE)) {
            String[] tokens = url.split(":");
            if (tokens.length != 6) {
                return Optional.empty();
            }
            return Optional.of(ESEventOriginContext.create(tokens[4], tokens[5]));
        }
        return Optional.empty();
    }

    private static void checkArgument(String name, String value) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)value) ? 1 : 0) != 0, (Object)(name + " cannot be null or empty"));
    }

    @AutoValue
    public static abstract class ESEventOriginContext {
        public abstract String indexName();

        public abstract String messageId();

        public static ESEventOriginContext create(String indexName, String messageId) {
            return new AutoValue_EventOriginContext_ESEventOriginContext(indexName, messageId);
        }
    }
}

