/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.failure;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.graylog.failure.FailureBatch;
import org.graylog.failure.FailureHandlingConfiguration;
import org.graylog.failure.FailureSubmissionQueue;
import org.graylog.failure.IndexingFailure;
import org.graylog.failure.IndexingFailureCause;
import org.graylog.failure.ProcessingFailure;
import org.graylog.failure.ProcessingFailureCause;
import org.graylog2.indexer.messages.Messages;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class FailureSubmissionService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final FailureSubmissionQueue failureSubmissionQueue;
    private final FailureHandlingConfiguration failureHandlingConfiguration;

    @Inject
    public FailureSubmissionService(FailureSubmissionQueue failureSubmissionQueue, FailureHandlingConfiguration failureHandlingConfiguration) {
        this.failureSubmissionQueue = failureSubmissionQueue;
        this.failureHandlingConfiguration = failureHandlingConfiguration;
    }

    public boolean submitUnknownProcessingError(Message message, String details) {
        return this.submitProcessingErrorsInternal(message, (List<Message.ProcessingError>)ImmutableList.of((Object)new Message.ProcessingError(ProcessingFailureCause.UNKNOWN, "Encountered an unrecognizable processing error", details)));
    }

    public boolean submitProcessingErrors(Message message) {
        return this.submitProcessingErrorsInternal(message, message.processingErrors());
    }

    private boolean submitProcessingErrorsInternal(Message message, List<Message.ProcessingError> processingErrors) {
        if (!this.failureHandlingConfiguration.submitProcessingFailures()) {
            return true;
        }
        if (!message.supportsFailureHandling()) {
            this.logger.warn("Submitted a message with processing errors, which doesn't support failure handling!");
            return true;
        }
        if (processingErrors.isEmpty()) {
            return true;
        }
        if (!this.failureHandlingConfiguration.keepFailedMessageDuplicate()) {
            message.setFilterOut(true);
        }
        processingErrors.forEach(pe -> this.submitProcessingFailure(message, (Message.ProcessingError)pe));
        return this.failureHandlingConfiguration.keepFailedMessageDuplicate();
    }

    private void submitProcessingFailure(Message failedMessage, Message.ProcessingError processingError) {
        try {
            boolean needsAcknowledgement = !this.failureHandlingConfiguration.keepFailedMessageDuplicate();
            String messageId = StringUtils.isBlank((CharSequence)failedMessage.getMessageId()) ? failedMessage.getId() : failedMessage.getMessageId();
            String message = String.format(Locale.ENGLISH, "Failed to process message with id '%s': %s", StringUtils.isBlank((CharSequence)messageId) ? "UNKNOWN" : messageId, processingError.getMessage());
            ProcessingFailure processingFailure = new ProcessingFailure(processingError.getCause(), message, processingError.getDetails(), Tools.nowUTC(), failedMessage, needsAcknowledgement);
            this.failureSubmissionQueue.submitBlocking(FailureBatch.processingFailureBatch(processingFailure));
        }
        catch (InterruptedException ignored) {
            this.logger.warn("Failed to submit a processing failure for failure handling. The thread has been interrupted!");
            Thread.currentThread().interrupt();
        }
    }

    public void submitIndexingErrors(Collection<Messages.IndexingError> indexingErrors) {
        try {
            FailureBatch fb = FailureBatch.indexingFailureBatch(indexingErrors.stream().filter(ie -> {
                if (!ie.message().supportsFailureHandling()) {
                    this.logger.warn("Submitted a message with indexing errors, which doesn't support failure handling!");
                    return false;
                }
                return true;
            }).map(this::fromIndexingError).collect(Collectors.toList()));
            if (fb.size() > 0) {
                this.failureSubmissionQueue.submitBlocking(fb);
            }
        }
        catch (InterruptedException ignored) {
            this.logger.warn("Failed to submit {} indexing errors for failure handling. The thread has been interrupted!", (Object)indexingErrors.size());
            Thread.currentThread().interrupt();
        }
    }

    private IndexingFailure fromIndexingError(Messages.IndexingError indexingError) {
        return new IndexingFailure(indexingError.errorType() == Messages.IndexingError.ErrorType.MappingError ? IndexingFailureCause.MappingError : IndexingFailureCause.UNKNOWN, String.format(Locale.ENGLISH, "Failed to index message with id '%s' targeting '%s'", indexingError.message().getMessageId(), indexingError.index()), indexingError.errorMessage(), Tools.nowUTC(), indexingError.message(), indexingError.index());
    }
}

