/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.metrics.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class ReplaceableCollectorRegistry
extends CollectorRegistry {
    private final AtomicReference<CollectorRegistry> registryRef;

    public ReplaceableCollectorRegistry(AtomicReference<CollectorRegistry> registryRef) {
        this.registryRef = Objects.requireNonNull(registryRef, "registryRef cannot be null");
    }

    public void register(Collector m) {
        throw new UnsupportedOperationException("The dynamic Prometheus collector registry doesn't support register()");
    }

    public void unregister(Collector m) {
        throw new UnsupportedOperationException("The dynamic Prometheus collector registry doesn't support unregister()");
    }

    public void clear() {
        throw new UnsupportedOperationException("The dynamic Prometheus collector registry doesn't support clear()");
    }

    public Enumeration<Collector.MetricFamilySamples> metricFamilySamples() {
        return this.registryRef.get().metricFamilySamples();
    }

    public Enumeration<Collector.MetricFamilySamples> filteredMetricFamilySamples(Set<String> includedNames) {
        return this.registryRef.get().filteredMetricFamilySamples(includedNames);
    }

    public Double getSampleValue(String name) {
        return this.registryRef.get().getSampleValue(name);
    }

    public Double getSampleValue(String name, String[] labelNames, String[] labelValues) {
        return this.registryRef.get().getSampleValue(name, labelNames, labelValues);
    }
}

