/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.cef.parser;

import com.github.jcustenborder.cef.Message;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.graylog.plugins.cef.parser.CEFMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappedMessage
implements Message {
    private static final Logger LOG = LoggerFactory.getLogger(MappedMessage.class);
    private final Message message;
    private static final String LABEL_SUFFIX = "Label";
    private final boolean useFullNames;
    private final Map<String, Object> extensions;

    public MappedMessage(Message message, boolean useFullNames) {
        this.message = message;
        this.useFullNames = useFullNames;
        this.extensions = this.mapExtensions(message.extensions());
    }

    private Map<String, Object> mapExtensions(Map<String, String> extensions) {
        HashMap<String, Object> mappedExtensions = new HashMap<String, Object>();
        for (Map.Entry<String, String> extension : extensions.entrySet()) {
            String keyName = extension.getKey();
            if (keyName.endsWith(LABEL_SUFFIX)) {
                LOG.trace("Skipping label: {}", (Object)keyName);
                continue;
            }
            CEFMapping fieldMapping = CEFMapping.forKeyName(keyName);
            if (fieldMapping != null) {
                try {
                    mappedExtensions.put(this.getLabel(keyName, fieldMapping.getFullName(), extensions), fieldMapping.convert(extension.getValue()));
                }
                catch (Exception e) {
                    LOG.warn("Could not transform CEF field [{}] according to standard. Skipping.", (Object)keyName, (Object)e);
                }
                continue;
            }
            mappedExtensions.put(this.getLabel(keyName, keyName, extensions), extension.getValue());
        }
        return mappedExtensions;
    }

    private String getLabel(String keyName, String fullName, Map<String, String> extensions) {
        String labelName = keyName + LABEL_SUFFIX;
        return extensions.getOrDefault(labelName, this.useFullNames ? fullName : keyName);
    }

    public Date timestamp() {
        return this.message.timestamp();
    }

    public String host() {
        return this.message.host();
    }

    public int cefVersion() {
        return this.message.cefVersion();
    }

    public String deviceVendor() {
        return this.message.deviceVendor();
    }

    public String deviceProduct() {
        return this.message.deviceProduct();
    }

    public String deviceVersion() {
        return this.message.deviceVersion();
    }

    public String deviceEventClassId() {
        return this.message.deviceEventClassId();
    }

    public String name() {
        return this.message.name();
    }

    public String severity() {
        return this.message.severity();
    }

    public Map<String, String> extensions() {
        return this.message.extensions();
    }

    public Map<String, Object> mappedExtensions() {
        return this.extensions;
    }
}

