/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.ast.expressions;

import java.util.Collections;
import org.antlr.v4.runtime.Token;
import org.graylog.plugins.pipelineprocessor.ast.expressions.BaseExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.Expression;
import org.graylog.plugins.pipelineprocessor.parser.ParseException;
import org.graylog.plugins.pipelineprocessor.parser.errors.SyntaxError;

public abstract class UnaryExpression
extends BaseExpression {
    protected Expression right;

    public UnaryExpression(Token start, Expression right) {
        super(start);
        this.right = UnaryExpression.requireNonNull(right, start);
    }

    private static Expression requireNonNull(Expression expression, Token token) {
        if (expression != null) {
            return expression;
        }
        int line = token.getLine();
        int positionInLine = token.getCharPositionInLine();
        String msg = "Invalid expression (line: " + line + ", column: " + positionInLine + ")";
        SyntaxError syntaxError = new SyntaxError(token.getText(), line, positionInLine, msg, null);
        throw new ParseException(Collections.singleton(syntaxError));
    }

    @Override
    public boolean isConstant() {
        return this.right.isConstant();
    }

    @Override
    public Class getType() {
        return this.right.getType();
    }

    public Expression right() {
        return this.right;
    }

    public void right(Expression right) {
        this.right = right;
    }

    @Override
    public Iterable<Expression> children() {
        return Collections.singleton(this.right);
    }
}

