/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.ast.functions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;

final class AutoValue_FunctionDescriptor<T>
extends FunctionDescriptor<T> {
    private final String name;
    private final boolean pure;
    private final Class<? extends T> returnType;
    private final ImmutableList<ParameterDescriptor> params;
    private final ImmutableMap<String, ParameterDescriptor> paramMap;
    private final String description;

    private AutoValue_FunctionDescriptor(String name, boolean pure, Class<? extends T> returnType, ImmutableList<ParameterDescriptor> params, ImmutableMap<String, ParameterDescriptor> paramMap, @Nullable String description) {
        this.name = name;
        this.pure = pure;
        this.returnType = returnType;
        this.params = params;
        this.paramMap = paramMap;
        this.description = description;
    }

    @Override
    @JsonProperty
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    public boolean pure() {
        return this.pure;
    }

    @Override
    @JsonProperty
    public Class<? extends T> returnType() {
        return this.returnType;
    }

    @Override
    @JsonProperty
    public ImmutableList<ParameterDescriptor> params() {
        return this.params;
    }

    @Override
    @JsonIgnore
    public ImmutableMap<String, ParameterDescriptor> paramMap() {
        return this.paramMap;
    }

    @Override
    @JsonProperty
    @Nullable
    public String description() {
        return this.description;
    }

    public String toString() {
        return "FunctionDescriptor{name=" + this.name + ", pure=" + this.pure + ", returnType=" + this.returnType + ", params=" + this.params + ", paramMap=" + this.paramMap + ", description=" + this.description + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FunctionDescriptor) {
            FunctionDescriptor that = (FunctionDescriptor)o;
            return this.name.equals(that.name()) && this.pure == that.pure() && this.returnType.equals(that.returnType()) && this.params.equals(that.params()) && this.paramMap.equals(that.paramMap()) && (this.description == null ? that.description() == null : this.description.equals(that.description()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.name.hashCode();
        h$ *= 1000003;
        h$ ^= this.pure ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.returnType.hashCode();
        h$ *= 1000003;
        h$ ^= this.params.hashCode();
        h$ *= 1000003;
        h$ ^= this.paramMap.hashCode();
        h$ *= 1000003;
        return h$ ^= this.description == null ? 0 : this.description.hashCode();
    }

    static final class Builder<T>
    extends FunctionDescriptor.Builder<T> {
        private String name;
        private Boolean pure;
        private Class<? extends T> returnType;
        private ImmutableList<ParameterDescriptor> params;
        private ImmutableMap<String, ParameterDescriptor> paramMap;
        private String description;

        Builder() {
        }

        @Override
        public FunctionDescriptor.Builder<T> name(String name) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            this.name = name;
            return this;
        }

        @Override
        public FunctionDescriptor.Builder<T> pure(boolean pure) {
            this.pure = pure;
            return this;
        }

        @Override
        public FunctionDescriptor.Builder<T> returnType(Class<? extends T> returnType) {
            if (returnType == null) {
                throw new NullPointerException("Null returnType");
            }
            this.returnType = returnType;
            return this;
        }

        @Override
        public FunctionDescriptor.Builder<T> params(ImmutableList<ParameterDescriptor> params) {
            if (params == null) {
                throw new NullPointerException("Null params");
            }
            this.params = params;
            return this;
        }

        @Override
        public ImmutableList<ParameterDescriptor> params() {
            if (this.params == null) {
                throw new IllegalStateException("Property \"params\" has not been set");
            }
            return this.params;
        }

        @Override
        public FunctionDescriptor.Builder<T> paramMap(ImmutableMap<String, ParameterDescriptor> paramMap) {
            if (paramMap == null) {
                throw new NullPointerException("Null paramMap");
            }
            this.paramMap = paramMap;
            return this;
        }

        @Override
        public FunctionDescriptor.Builder<T> description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @Override
        FunctionDescriptor<T> autoBuild() {
            String missing = "";
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.pure == null) {
                missing = missing + " pure";
            }
            if (this.returnType == null) {
                missing = missing + " returnType";
            }
            if (this.params == null) {
                missing = missing + " params";
            }
            if (this.paramMap == null) {
                missing = missing + " paramMap";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_FunctionDescriptor(this.name, this.pure, this.returnType, this.params, this.paramMap, this.description);
        }
    }
}

