/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.periodical;

import javax.inject.Inject;
import org.graylog.plugins.sidecar.services.SidecarService;
import org.graylog.plugins.sidecar.system.SidecarConfiguration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.periodical.Periodical;
import org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurgeExpiredSidecarsThread
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(PurgeExpiredSidecarsThread.class);
    private final SidecarService sidecarService;
    private final SidecarConfiguration sidecarConfiguration;

    @Inject
    public PurgeExpiredSidecarsThread(SidecarService sidecarService, ClusterConfigService clusterConfigService) {
        this.sidecarService = sidecarService;
        this.sidecarConfiguration = clusterConfigService.getOrDefault(SidecarConfiguration.class, SidecarConfiguration.defaultConfiguration());
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return true;
    }

    @Override
    public boolean masterOnly() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return 600;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void doRun() {
        Period inactiveThreshold = this.sidecarConfiguration.sidecarInactiveThreshold();
        int expiredSidecars = this.sidecarService.markExpired(inactiveThreshold, "Received no ping signal from sidecar");
        LOG.debug("Marked {} sidecars as inactive.", (Object)expiredSidecars);
        int purgedSidecars = this.sidecarService.destroyExpired(this.sidecarConfiguration.sidecarExpirationThreshold());
        LOG.debug("Purged {} inactive sidecars.", (Object)purgedSidecars);
    }
}

