/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.ElasticsearchQueryString;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.OffsetRange;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.Pivot;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.RandomUUIDProvider;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.SearchType;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.TimeRange;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.ViewWidget;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets.AggregationConfig;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets.NumberVisualizationConfig;

@AutoValue
public abstract class AggregationWidget
implements ViewWidget {
    private static final String TYPE_AGGREGATION = "aggregation";
    private static final String FIELD_ID = "id";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_FILTER = "filter";
    private static final String FIELD_CONFIG = "config";
    private static final String FIELD_TIMERANGE = "timerange";
    private static final String FIELD_QUERY = "query";
    private static final String FIELD_STREAMS = "streams";

    @Override
    @JsonProperty(value="id")
    public abstract String id();

    @JsonProperty(value="type")
    abstract String type();

    @JsonProperty(value="filter")
    @Nullable
    abstract String filter();

    @JsonProperty(value="timerange")
    abstract TimeRange timerange();

    @JsonProperty(value="query")
    abstract ElasticsearchQueryString query();

    @JsonProperty(value="streams")
    abstract Set<String> streams();

    @JsonProperty(value="config")
    public abstract AggregationConfig config();

    public static Builder builder() {
        return new .AutoValue_AggregationWidget.Builder().type(TYPE_AGGREGATION).streams(Collections.emptySet());
    }

    @Override
    public Set<SearchType> toSearchTypes(RandomUUIDProvider randomUUIDProvider) {
        Pivot.Builder chartBuilder = Pivot.builder().id(randomUUIDProvider.get()).name("chart").query(this.query()).streams(this.streams()).timerange(this.timerange()).rollup(this.config().rollup()).rowGroups(this.config().rowPivots().stream().map(pivot -> pivot.toBucketSpec()).collect(Collectors.toList())).columnGroups(this.config().columnPivots().stream().map(pivot -> pivot.toBucketSpec()).collect(Collectors.toList())).series(this.config().series().stream().map(series -> series.toSeriesSpec()).collect(Collectors.toList())).sort(this.config().sort().stream().map(sort -> sort.toSortSpec()).collect(Collectors.toList()));
        if (this.config().visualization().equals("numeric") && this.config().visualizationConfig().map(visualizationConfig -> ((NumberVisualizationConfig)visualizationConfig).trend()).orElse(false).booleanValue()) {
            Pivot chart = chartBuilder.build();
            Pivot trend = chartBuilder.id(randomUUIDProvider.get()).name("trend").timerange(OffsetRange.ofSearchTypeId(chart.id())).build();
            return ImmutableSet.of((Object)chart, (Object)trend);
        }
        return Collections.singleton(chartBuilder.build());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonProperty(value="id")
        public abstract Builder id(String var1);

        @JsonProperty(value="type")
        public abstract Builder type(String var1);

        @JsonProperty(value="filter")
        @Nullable
        public abstract Builder filter(String var1);

        @JsonProperty(value="timerange")
        public abstract Builder timerange(TimeRange var1);

        @JsonProperty(value="query")
        abstract Builder query(ElasticsearchQueryString var1);

        public Builder query(String query) {
            return this.query(ElasticsearchQueryString.create(query));
        }

        @JsonProperty(value="streams")
        public abstract Builder streams(Set<String> var1);

        @JsonProperty(value="config")
        public abstract Builder config(AggregationConfig var1);

        public abstract AggregationWidget build();
    }
}

