/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.view;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.search.SeriesSpec;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.view.AutoValue_Series;

@AutoValue
public abstract class Series {
    private static final String FIELD_CONFIG = "config";
    private static final String FIELD_FUNCTION = "function";
    private static final Pattern destructuringPattern = Pattern.compile("(\\w+)\\((\\w+)?\\)");

    @JsonProperty(value="config")
    public Map<String, Object> config() {
        return Collections.emptyMap();
    }

    @JsonProperty(value="function")
    public String function() {
        return "count()";
    }

    public static Series create() {
        return new AutoValue_Series();
    }

    public SeriesSpec toSeriesSpec() {
        Matcher matcher = destructuringPattern.matcher(this.function());
        if (matcher.matches()) {
            String functionName = matcher.group(1);
            String optionalFieldName = matcher.group(2);
            return SeriesSpec.create(functionName, this.function(), optionalFieldName);
        }
        throw new RuntimeException("Unable to parse function: " + this.function());
    }
}

