/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.migrations.V20200204122000_MigrateUntypedViewsToDashboards;

import java.util.Map;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.graylog.plugins.views.migrations.V20200204122000_MigrateUntypedViewsToDashboards.ViewState;

class View {
    private static final String FIELD_ID = "_id";
    private static final String FIELD_SEARCH_ID = "search_id";
    private static final String FIELD_STATES = "state";
    private static final String FIELD_TYPE = "type";
    private static final String TYPE_DASHBOARD = "DASHBOARD";
    private final Document viewDocument;

    View(Document viewDocument) {
        this.viewDocument = viewDocument;
    }

    ObjectId objectId() {
        return this.viewDocument.getObjectId((Object)FIELD_ID);
    }

    String searchId() {
        return this.viewDocument.getString((Object)FIELD_SEARCH_ID);
    }

    Map<String, ViewState> viewStates() {
        Document states = (Document)this.viewDocument.get((Object)FIELD_STATES, Document.class);
        return states.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new ViewState((Document)entry.getValue())));
    }

    void makeDashboard() {
        this.viewDocument.put(FIELD_TYPE, (Object)TYPE_DASHBOARD);
    }

    Document viewDocument() {
        return this.viewDocument;
    }
}

