/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search;

import com.google.common.base.Joiner;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.errors.MissingCapabilitiesException;
import org.graylog.plugins.views.search.views.PluginMetadataSummary;
import org.graylog2.plugin.PluginMetaData;
import org.graylog2.shared.rest.exceptions.MissingStreamPermissionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchExecutionGuard {
    private static final Logger LOG = LoggerFactory.getLogger(SearchExecutionGuard.class);
    private final Map<String, PluginMetaData> providedCapabilities;

    @Inject
    public SearchExecutionGuard(Map<String, PluginMetaData> providedCapabilities) {
        this.providedCapabilities = providedCapabilities;
    }

    public void check(Search search, Predicate<String> hasReadPermissionForStream) {
        this.checkUserIsPermittedToSeeStreams(search.streamIdsForPermissionsCheck(), hasReadPermissionForStream);
        this.checkMissingRequirements(search);
    }

    public void checkUserIsPermittedToSeeStreams(Set<String> streamIds, Predicate<String> hasReadPermissionForStream) {
        Predicate<String> isForbidden = hasReadPermissionForStream.negate();
        Set<String> forbiddenStreams = streamIds.stream().filter(isForbidden).collect(Collectors.toSet());
        if (!forbiddenStreams.isEmpty()) {
            this.throwExceptionMentioningStreamIds(forbiddenStreams);
        }
    }

    private void throwExceptionMentioningStreamIds(Set<String> forbiddenStreams) {
        LOG.warn("Not executing search, it is referencing inaccessible streams: [" + Joiner.on((char)',').join(forbiddenStreams) + "]");
        throw new MissingStreamPermissionException("The search is referencing at least one stream you are not permitted to see.", forbiddenStreams);
    }

    private void checkMissingRequirements(Search search) {
        Map<String, PluginMetadataSummary> missingRequirements = this.missingRequirementsForEach(search);
        if (!missingRequirements.isEmpty()) {
            throw new MissingCapabilitiesException(missingRequirements);
        }
    }

    private Map<String, PluginMetadataSummary> missingRequirementsForEach(Search search) {
        return search.requires().entrySet().stream().filter(entry -> !this.providedCapabilities.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

