/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.elasticsearch;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog2.indexer.fieldtypes.FieldTypeDTO;
import org.graylog2.indexer.fieldtypes.IndexFieldTypesService;

public class FieldTypesLookup {
    private final IndexFieldTypesService indexFieldTypesService;

    @Inject
    public FieldTypesLookup(IndexFieldTypesService indexFieldTypesService) {
        this.indexFieldTypesService = indexFieldTypesService;
    }

    private Map<String, Set<String>> get(Set<String> streamIds) {
        return this.indexFieldTypesService.findForStreamIds(streamIds).stream().flatMap(indexFieldTypes -> indexFieldTypes.fields().stream()).collect(Collectors.toMap(FieldTypeDTO::fieldName, fieldType -> Collections.singleton(fieldType.physicalType()), Sets::union));
    }

    public Optional<String> getType(Set<String> streamIds, String field) {
        Map<String, Set<String>> allFieldTypes = this.get(streamIds);
        Set<String> fieldTypes = allFieldTypes.get(field);
        return fieldTypes == null || fieldTypes.size() > 1 ? Optional.empty() : fieldTypes.stream().findFirst();
    }
}

