/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.engine;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.QueryMetadata;
import org.graylog.plugins.views.search.QueryMetadataDecorator;
import org.graylog.plugins.views.search.QueryResult;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.engine.GeneratedQueryContext;
import org.graylog.plugins.views.search.engine.QueryBackend;
import org.graylog.plugins.views.search.engine.QueryParser;
import org.graylog.plugins.views.search.engine.QueryPlan;
import org.graylog.plugins.views.search.errors.QueryError;
import org.graylog.plugins.views.search.errors.SearchError;
import org.graylog.plugins.views.search.errors.SearchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class QueryEngine {
    private static final Logger LOG = LoggerFactory.getLogger(QueryEngine.class);
    private final Set<QueryMetadataDecorator> queryMetadataDecorators;
    private final QueryParser queryParser;
    private final Executor queryPool = Executors.newFixedThreadPool(4, new ThreadFactoryBuilder().setNameFormat("query-engine-%d").build());
    private final QueryBackend<? extends GeneratedQueryContext> elasticsearchBackend;

    @Inject
    public QueryEngine(QueryBackend<? extends GeneratedQueryContext> elasticsearchBackend, Set<QueryMetadataDecorator> queryMetadataDecorators, QueryParser queryParser) {
        this.elasticsearchBackend = elasticsearchBackend;
        this.queryMetadataDecorators = queryMetadataDecorators;
        this.queryParser = queryParser;
    }

    @Deprecated
    public QueryEngine(Map<String, QueryBackend<? extends GeneratedQueryContext>> backends, Set<QueryMetadataDecorator> queryMetadataDecorators, QueryParser queryParser) {
        this(backends.get("elasticsearch"), queryMetadataDecorators, queryParser);
    }

    private static Set<QueryResult> allOfResults(Set<CompletableFuture<QueryResult>> futures) {
        return (Set)((CompletableFuture)CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).handle((aVoid, throwable) -> (ImmutableSet)futures.stream().map(f -> f.handle((queryResult, throwable1) -> {
            if (throwable1 != null) {
                return QueryResult.incomplete();
            }
            return queryResult;
        })).map(CompletableFuture::join).collect(ImmutableSet.toImmutableSet()))).join();
    }

    public QueryMetadata parse(Search search, Query query) {
        QueryMetadata parsedMetadata = this.queryParser.parse(query);
        return this.queryMetadataDecorators.stream().reduce((decorator1, decorator2) -> (s, q, metadata) -> decorator1.decorate(s, q, decorator2.decorate(s, q, metadata))).map(decorator -> decorator.decorate(search, query, parsedMetadata)).orElse(parsedMetadata);
    }

    public SearchJob execute(SearchJob searchJob) {
        QueryPlan plan = new QueryPlan(this, searchJob);
        plan.queries().forEach(query -> searchJob.addQueryResultFuture(query.id(), (CompletableFuture<QueryResult>)CompletableFuture.supplyAsync(() -> this.prepareAndRun(plan, searchJob, (Query)query), this.queryPool).handle((queryResult, throwable) -> {
            if (throwable != null) {
                Throwable cause = throwable.getCause();
                SearchError error = cause instanceof SearchException ? ((SearchException)cause).error() : new QueryError((Query)query, cause);
                LOG.debug("Running query {} failed: {}", (Object)query.id(), (Object)cause);
                searchJob.addError(error);
                return QueryResult.failedQueryWithError(query, error);
            }
            return queryResult;
        })));
        searchJob.addQueryResultFuture("", CompletableFuture.completedFuture(QueryResult.emptyResult()));
        plan.breadthFirst().forEachOrdered(query -> {
            CompletableFuture<QueryResult> queryResultFuture = searchJob.getQueryResultFuture(query.id());
            if (!queryResultFuture.isDone()) {
                QueryResult queryResult = queryResultFuture.join();
            } else {
                LOG.debug("[{}] Not generating query for query {}", (Object)StringUtils.defaultIfEmpty((CharSequence)query.id(), (CharSequence)"root"), query);
            }
        });
        LOG.debug("Search job {} executing with plan {}", (Object)searchJob.getId(), (Object)plan);
        return searchJob.seal();
    }

    private QueryResult prepareAndRun(QueryPlan plan, SearchJob searchJob, Query query) {
        Set<Query> predecessors = plan.predecessors(query);
        LOG.debug("[{}] Processing query, requires {} results, has {} subqueries", new Object[]{StringUtils.defaultIfEmpty((CharSequence)query.id(), (CharSequence)"root"), predecessors.size(), plan.successors(query).size()});
        QueryBackend<? extends GeneratedQueryContext> backend = this.getQueryBackend(query);
        LOG.debug("[{}] Using {} to generate query", (Object)query.id(), backend);
        LOG.debug("[{}] Waiting for results: {}", (Object)query.id(), predecessors);
        Set<QueryResult> results = QueryEngine.allOfResults(predecessors.stream().map(Query::id).map(searchJob::getQueryResultFuture).filter(Objects::nonNull).collect(Collectors.toSet()));
        LOG.debug("[{}] Preparing query execution with results of queries: ({})", (Object)query.id(), (Object)StreamEx.of(results.stream()).map(QueryResult::query).map(Query::id).joining());
        GeneratedQueryContext generatedQueryContext = backend.generate(searchJob, query, results);
        LOG.trace("[{}] Generated query {}, running it on backend {}", new Object[]{query.id(), generatedQueryContext, backend});
        QueryResult result = backend.run(searchJob, query, generatedQueryContext, results);
        LOG.debug("[{}] Query returned {}", (Object)query.id(), (Object)result);
        if (!generatedQueryContext.errors().isEmpty()) {
            generatedQueryContext.errors().forEach(searchJob::addError);
        }
        return result;
    }

    private QueryBackend<? extends GeneratedQueryContext> getQueryBackend(Query query) {
        return this.elasticsearchBackend;
    }
}

