/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.export;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.plugins.views.search.LegacyDecoratorProcessor;
import org.graylog.plugins.views.search.export.ChunkDecorator;
import org.graylog.plugins.views.search.export.ExportMessagesCommand;
import org.graylog.plugins.views.search.export.SimpleMessage;
import org.graylog.plugins.views.search.export.SimpleMessageChunk;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.rest.models.messages.responses.ResultMessageSummary;
import org.graylog2.rest.resources.search.responses.SearchResponse;

public class LegacyChunkDecorator
implements ChunkDecorator {
    private final LegacyDecoratorProcessor decoratorProcessor;

    @Inject
    public LegacyChunkDecorator(LegacyDecoratorProcessor decoratorProcessor) {
        this.decoratorProcessor = decoratorProcessor;
    }

    @Override
    public SimpleMessageChunk decorate(SimpleMessageChunk undecoratedChunk, ExportMessagesCommand command) {
        SearchResponse undecoratedLegacyResponse = this.legacySearchResponseFrom(undecoratedChunk, command);
        SearchResponse decoratedLegacyResponse = this.decoratorProcessor.decorateSearchResponse(undecoratedLegacyResponse, command.decorators());
        SimpleMessageChunk decoratedChunk = this.simpleMessageChunkFrom(decoratedLegacyResponse, undecoratedChunk.fieldsInOrder());
        return decoratedChunk.toBuilder().chunkOrder(undecoratedChunk.chunkOrder()).build();
    }

    private SimpleMessageChunk simpleMessageChunkFrom(SearchResponse searchResponse, LinkedHashSet<String> fieldsInOrder) {
        LinkedHashSet messages = searchResponse.messages().stream().map(legacyMessage -> SimpleMessage.from(legacyMessage.index(), new LinkedHashMap<String, Object>(legacyMessage.message()))).collect(Collectors.toCollection(LinkedHashSet::new));
        return SimpleMessageChunk.from(fieldsInOrder, messages);
    }

    private SearchResponse legacySearchResponseFrom(SimpleMessageChunk chunk, ExportMessagesCommand command) {
        List<ResultMessageSummary> legacyMessages = this.legacyMessagesFrom(chunk);
        String queryString = command.queryString().queryString();
        AbsoluteRange timeRange = command.timeRange();
        return SearchResponse.create(queryString, queryString, Collections.emptySet(), legacyMessages, chunk.fieldsInOrder(), -1L, -1L, ((TimeRange)timeRange).getFrom(), ((TimeRange)timeRange).getTo());
    }

    private List<ResultMessageSummary> legacyMessagesFrom(SimpleMessageChunk chunk) {
        return chunk.messages().stream().map(simpleMessage -> ResultMessageSummary.create((Multimap<String, Range<Integer>>)ImmutableMultimap.of(), simpleMessage.fields(), simpleMessage.index())).collect(Collectors.toList());
    }
}

