/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.timeranges;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.GlobalOverride;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.timeranges.AutoValue_OffsetRange;
import org.graylog.plugins.views.search.timeranges.DerivableTimeRange;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;

@JsonTypeName(value="offset")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class OffsetRange
extends TimeRange
implements DerivableTimeRange {
    public static final String OFFSET = "offset";
    private static final Pattern INTERVAL_OFFSET = Pattern.compile("(\\d+)i");

    @Override
    @JsonProperty
    public abstract String type();

    @JsonProperty
    public abstract String source();

    @JsonProperty
    public abstract Optional<String> id();

    @JsonProperty
    public abstract String offset();

    @Override
    public DateTime getFrom() {
        throw new IllegalStateException("OffsetRange is not able to return its start point on its own. Please use DerivedTimeRange#effectiveTimeRange instead.");
    }

    @Override
    public DateTime getTo() {
        throw new IllegalStateException("OffsetRange is not able to return its end point on its own. Please use DerivedTimeRange#effectiveTimeRange instead.");
    }

    private TimeRange timeRangeOfSource(String source, Optional<String> id, Query query, SearchType searchType) {
        switch (source.toLowerCase(Locale.ROOT)) {
            case "query": {
                return query.timerange();
            }
            case "search_type": {
                String searchTypeId = id.orElseThrow(() -> new RuntimeException("Search type " + searchType.id() + " has offset timerange referencing search type but id is missing!"));
                return query.searchTypes().stream().filter(s -> s.id().equals(searchTypeId)).findFirst().map(query::effectiveTimeRange).orElseThrow(() -> new RuntimeException("Search type " + searchType.id() + " has offset timerange referencing invalid search type: " + searchTypeId));
            }
        }
        throw new RuntimeException("Search type " + searchType.id() + " has offset timerange referencing invalid source: " + source);
    }

    private Optional<Integer> parseIntervalOffset(String offset) {
        Matcher intervalMatcher = INTERVAL_OFFSET.matcher(offset);
        if (intervalMatcher.matches()) {
            try {
                return Optional.of(Integer.parseInt(intervalMatcher.group(1), 10));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Offset time range has invalid interval specification: " + offset, e);
            }
        }
        return Optional.empty();
    }

    private long deltaFromOffset(String offset, TimeRange referenceTimeRange) {
        return this.parseIntervalOffset(offset).map(intervals -> new Duration((ReadableInstant)referenceTimeRange.getFrom(), (ReadableInstant)referenceTimeRange.getTo()).getMillis() * (long)intervals.intValue()).orElseGet(() -> (long)Integer.parseInt(offset, 10) * 1000L);
    }

    private TimeRange deriveTimeRange(TimeRange referenceTimeRange) {
        long delta = this.deltaFromOffset(this.offset(), referenceTimeRange);
        return AbsoluteRange.create(referenceTimeRange.getFrom().minus(delta), referenceTimeRange.getTo().minus(delta));
    }

    @Override
    public TimeRange deriveTimeRange(Query query, SearchType searchType) {
        TimeRange referenceTimeRange = query.globalOverride().flatMap(GlobalOverride::timerange).orElseGet(() -> this.timeRangeOfSource(this.source(), this.id(), query, searchType));
        return this.deriveTimeRange(referenceTimeRange);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonProperty
        public abstract Builder type(String var1);

        @JsonProperty
        public abstract Builder source(String var1);

        @JsonProperty
        public abstract Builder id(@Nullable String var1);

        @JsonProperty
        public abstract Builder offset(String var1);

        public Builder offset(Integer offset) {
            return this.offset(offset.toString());
        }

        @JsonCreator
        public static Builder builder() {
            return new AutoValue_OffsetRange.Builder().type(OffsetRange.OFFSET).offset("1i");
        }

        public abstract OffsetRange build();
    }
}

