/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.scheduler.eventbus;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.eventbus.EventBus;

public class JobSchedulerEventBus
extends EventBus {
    private final Counter registrationsCount;
    private final Timer postTimer;

    public JobSchedulerEventBus(String name, MetricRegistry metricRegistry) {
        super(name);
        this.registrationsCount = metricRegistry.counter(MetricRegistry.name(((Object)((Object)this)).getClass(), (String[])new String[]{name, "registrations"}));
        this.postTimer = metricRegistry.timer(MetricRegistry.name(((Object)((Object)this)).getClass(), (String[])new String[]{name, "posts"}));
    }

    public void register(Object object) {
        this.registrationsCount.inc();
        super.register(object);
    }

    public void unregister(Object object) {
        this.registrationsCount.dec();
        super.unregister(object);
    }

    public void post(Object event) {
        try (Timer.Context ignored = this.postTimer.time();){
            super.post(event);
        }
    }
}

