/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security;

import com.google.common.base.Preconditions;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.graylog.grn.GRN;
import org.graylog.grn.GRNRegistry;
import org.graylog2.plugin.database.users.User;

public class GranteeAuthorizer {
    private final Subject subject;

    @AssistedInject
    public GranteeAuthorizer(DefaultSecurityManager securityManager, GRNRegistry grnRegistry, @Assisted User grantee) {
        this(securityManager, grnRegistry.ofUser(grantee));
    }

    @AssistedInject
    public GranteeAuthorizer(DefaultSecurityManager securityManager, @Assisted GRN grantee) {
        this.subject = new Subject.Builder((SecurityManager)securityManager).principals((PrincipalCollection)new SimplePrincipalCollection((Object)grantee, "GranteeAuthorizer")).authenticated(true).sessionCreationEnabled(false).buildSubject();
    }

    public boolean isPermitted(String permission, GRN target) {
        return this.isPermitted(permission, target.entity());
    }

    public boolean isPermitted(String permission) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)permission), (Object)"permission cannot be null or empty");
        return this.subject.isPermitted(permission);
    }

    public boolean isPermitted(String permission, String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)permission), (Object)"permission cannot be null or empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)id), (Object)"id cannot be null or empty");
        return this.subject.isPermitted(permission + ":" + id);
    }

    public static interface Factory {
        public GranteeAuthorizer create(GRN var1);

        public GranteeAuthorizer create(User var1);
    }
}

