/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.authservice.ldap;

import com.google.auto.value.AutoValue;
import java.util.EnumSet;
import java.util.stream.Collectors;
import org.graylog.security.authservice.ldap.AutoValue_ADUserAccountControl;

@AutoValue
public abstract class ADUserAccountControl {
    public abstract EnumSet<Flags> flags();

    public static ADUserAccountControl create(int userAccountControlField) {
        EnumSet<Flags> set = EnumSet.noneOf(Flags.class);
        for (Flags flag : Flags.values()) {
            if (!flag.isSetIn(userAccountControlField)) continue;
            set.add(flag);
        }
        return new AutoValue_ADUserAccountControl(set);
    }

    public boolean accountIsDisabled() {
        return this.flags().contains((Object)Flags.ACCOUNTDISABLE);
    }

    public boolean isUserAccount() {
        return this.flags().contains((Object)Flags.NORMAL_ACCOUNT);
    }

    public boolean passwordExpired() {
        return this.flags().contains((Object)Flags.PASSWORD_EXPIRED);
    }

    public String printFlags() {
        return this.flags().stream().sorted().map(Enum::toString).collect(Collectors.joining("|"));
    }

    public static enum Flags {
        ACCOUNTDISABLE(2),
        NORMAL_ACCOUNT(512),
        PASSWORD_EXPIRED(0x800000);

        private final int flagValue;

        public int getFlagValue() {
            return this.flagValue;
        }

        private Flags(int flagValue) {
            this.flagValue = flagValue;
        }

        public boolean isSetIn(int userAccountControlValue) {
            return (userAccountControlValue & this.flagValue) > 0;
        }
    }
}

