/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.shares;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import org.graylog.grn.GRN;
import org.graylog.grn.GRNRegistry;
import org.graylog.security.GranteeAuthorizer;
import org.graylog.security.shares.EntityShareResponse;
import org.graylog.security.shares.GranteeService;
import org.graylog2.plugin.database.users.User;
import org.graylog2.shared.users.UserService;

public class DefaultGranteeService
implements GranteeService {
    protected final UserService userService;
    protected final GRNRegistry grnRegistry;
    protected final GranteeAuthorizer.Factory granteeAuthorizerFactory;

    @Inject
    public DefaultGranteeService(UserService userService, GRNRegistry grnRegistry, GranteeAuthorizer.Factory granteeAuthorizerFactory) {
        this.userService = userService;
        this.grnRegistry = grnRegistry;
        this.granteeAuthorizerFactory = granteeAuthorizerFactory;
    }

    public ImmutableSet<EntityShareResponse.AvailableGrantee> getAvailableGrantees(User sharingUser) {
        return ImmutableSet.builder().addAll(this.getAvailableUserGrantees(sharingUser)).add((Object)this.getGlobalGrantee()).build();
    }

    @Override
    public Set<GRN> getGranteeAliases(GRN grantee) {
        return Collections.singleton(grantee);
    }

    @Override
    public Set<User> getVisibleUsers(User requestingUser) {
        GranteeAuthorizer userAuthorizer = this.granteeAuthorizerFactory.create(requestingUser);
        if (userAuthorizer.isPermitted("users:list")) {
            return (Set)this.userService.loadAll().stream().collect(ImmutableSet.toImmutableSet());
        }
        return (Set)this.userService.loadAll().stream().filter(u -> userAuthorizer.isPermitted("users:read", u.getName())).collect(ImmutableSet.toImmutableSet());
    }

    private ImmutableSet<EntityShareResponse.AvailableGrantee> getAvailableUserGrantees(User sharingUser) {
        return (ImmutableSet)this.getVisibleUsers(sharingUser).stream().filter(user -> !sharingUser.getId().equals(user.getId())).map(user -> EntityShareResponse.AvailableGrantee.create(this.grnRegistry.ofUser((User)user), "user", user.getFullName())).collect(ImmutableSet.toImmutableSet());
    }

    private EntityShareResponse.AvailableGrantee getGlobalGrantee() {
        return EntityShareResponse.AvailableGrantee.create(GRNRegistry.GLOBAL_USER_GRN, "global", "Everyone");
    }
}

