/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alarmcallbacks;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mongodb.DBCollection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.alarmcallbacks.AlarmCallbackConfiguration;
import org.graylog2.alarmcallbacks.AlarmCallbackConfigurationImpl;
import org.graylog2.alarmcallbacks.AlarmCallbackConfigurationService;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.CollectionName;
import org.graylog2.database.MongoConnection;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.rest.models.alarmcallbacks.requests.CreateAlarmCallbackRequest;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.JacksonDBCollection;

public class AlarmCallbackConfigurationServiceImpl
implements AlarmCallbackConfigurationService {
    private final JacksonDBCollection<AlarmCallbackConfigurationImpl, String> coll;

    @Inject
    public AlarmCallbackConfigurationServiceImpl(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapperProvider) {
        String collectionName = AlarmCallbackConfigurationImpl.class.getAnnotation(CollectionName.class).value();
        DBCollection dbCollection = mongoConnection.getDatabase().getCollection(collectionName);
        this.coll = JacksonDBCollection.wrap((DBCollection)dbCollection, AlarmCallbackConfigurationImpl.class, String.class, (ObjectMapper)mapperProvider.get());
        dbCollection.createIndex("stream_id");
    }

    @Override
    public List<AlarmCallbackConfiguration> getForStreamId(String streamId) {
        try (DBCursor dbCursor = this.coll.find(DBQuery.is((String)"stream_id", (Object)streamId));){
            ImmutableList immutableList = ImmutableList.copyOf((Iterable)dbCursor);
            return immutableList;
        }
    }

    @Override
    public List<AlarmCallbackConfiguration> getForStream(Stream stream) {
        return this.getForStreamId(stream.getId());
    }

    @Override
    public AlarmCallbackConfiguration load(String alarmCallbackId) {
        return (AlarmCallbackConfiguration)this.coll.findOneById((Object)alarmCallbackId);
    }

    @Override
    public AlarmCallbackConfiguration create(String streamId, CreateAlarmCallbackRequest request, String userId) {
        return AlarmCallbackConfigurationImpl.create(new ObjectId().toHexString(), streamId, request.type(), request.title(), request.configuration(), new Date(), userId);
    }

    @Override
    public long count() {
        return this.coll.count();
    }

    @Override
    public Map<String, Long> countPerType() {
        HashMap result = Maps.newHashMap();
        try (DBCursor avs = this.coll.find();){
            for (AlarmCallbackConfigurationImpl av : avs) {
                Long count = (Long)result.get(av.getType());
                if (count == null) {
                    count = 0L;
                }
                result.put(av.getType(), count + 1L);
            }
        }
        return result;
    }

    @Override
    public String save(AlarmCallbackConfiguration model) throws ValidationException {
        return (String)this.coll.save((Object)this.implOrFail(model)).getSavedId();
    }

    @Override
    public int destroy(AlarmCallbackConfiguration model) {
        return this.coll.removeById((Object)model.getId()).getN();
    }

    private AlarmCallbackConfigurationImpl implOrFail(AlarmCallbackConfiguration callback) {
        if (callback instanceof AlarmCallbackConfigurationImpl) {
            AlarmCallbackConfigurationImpl callbackImpl = (AlarmCallbackConfigurationImpl)callback;
            return callbackImpl;
        }
        throw new IllegalArgumentException("Supplied output must be of implementation type AlarmCallbackConfigurationAVImpl, not " + callback.getClass());
    }
}

