/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import com.github.zafarkhaja.semver.Version;
import javax.annotation.Nonnull;
import org.graylog2.indexer.ElasticsearchException;
import org.graylog2.indexer.IndexMapping;
import org.graylog2.indexer.IndexMapping5;
import org.graylog2.indexer.IndexMapping6;
import org.graylog2.indexer.IndexMapping7;
import org.graylog2.indexer.IndexTemplateProvider;
import org.graylog2.indexer.indexset.IndexSetConfig;

public class MessageIndexTemplateProvider
implements IndexTemplateProvider {
    public static final String MESSAGE_TEMPLATE_TYPE = "messages";

    @Override
    public IndexMapping create(@Nonnull Version elasticsearchVersion, @Nonnull IndexSetConfig indexSetConfig) {
        if (elasticsearchVersion.satisfies("^5.0.0")) {
            return new IndexMapping5();
        }
        if (elasticsearchVersion.satisfies("^6.0.0")) {
            return new IndexMapping6();
        }
        if (elasticsearchVersion.satisfies("^7.0.0")) {
            return new IndexMapping7();
        }
        throw new ElasticsearchException("Unsupported Elasticsearch version: " + elasticsearchVersion);
    }
}

