/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.cluster;

import com.github.zafarkhaja.semver.Version;
import java.util.Optional;
import javax.inject.Inject;
import org.graylog2.indexer.ElasticsearchException;
import org.graylog2.indexer.cluster.NodeAdapter;

public class Node {
    private final NodeAdapter nodeAdapter;

    @Inject
    public Node(NodeAdapter nodeAdapter) {
        this.nodeAdapter = nodeAdapter;
    }

    public Optional<Version> getVersion() {
        return this.nodeAdapter.version().map(this::parseVersion);
    }

    private Version parseVersion(String version) {
        try {
            return Version.valueOf((String)version);
        }
        catch (Exception e) {
            throw new ElasticsearchException("Unable to parse Elasticsearch version: " + version, (Throwable)e);
        }
    }
}

