/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.fieldtypes;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.graylog.plugins.views.search.elasticsearch.IndexLookup;
import org.graylog.plugins.views.search.rest.MappedFieldTypeDTO;
import org.graylog2.indexer.fieldtypes.FieldTypeDTO;
import org.graylog2.indexer.fieldtypes.FieldTypeMapper;
import org.graylog2.indexer.fieldtypes.FieldTypes;
import org.graylog2.indexer.fieldtypes.IndexFieldTypesService;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.streams.StreamService;

public class MappedFieldTypesService {
    private final StreamService streamService;
    private final IndexFieldTypesService indexFieldTypesService;
    private final FieldTypeMapper fieldTypeMapper;
    private final IndexLookup indexLookup;
    private static final FieldTypes.Type UNKNOWN_TYPE = FieldTypes.Type.createType("unknown", (Set<String>)ImmutableSet.of());
    private static final String PROP_COMPOUND_TYPE = "compound";

    @Inject
    public MappedFieldTypesService(StreamService streamService, IndexFieldTypesService indexFieldTypesService, FieldTypeMapper fieldTypeMapper, IndexLookup indexLookup) {
        this.streamService = streamService;
        this.indexFieldTypesService = indexFieldTypesService;
        this.fieldTypeMapper = fieldTypeMapper;
        this.indexLookup = indexLookup;
    }

    public Set<MappedFieldTypeDTO> fieldTypesByStreamIds(Collection<String> streamIds, TimeRange timeRange) {
        Set<String> indexSets = this.streamService.indexSetIdsByIds(streamIds);
        Set<String> indexNames = this.indexLookup.indexNamesForStreamsInTimeRange((Set<String>)ImmutableSet.copyOf(streamIds), timeRange);
        Stream<MappedFieldTypeDTO> types = this.indexFieldTypesService.findForIndexSets(indexSets).stream().filter(fieldTypes -> indexNames.contains(fieldTypes.indexName())).flatMap(fieldTypes -> fieldTypes.fields().stream()).map(this::mapPhysicalFieldType);
        return this.mergeCompoundFieldTypes(types);
    }

    private MappedFieldTypeDTO mapPhysicalFieldType(FieldTypeDTO fieldType) {
        FieldTypes.Type mappedFieldType = this.fieldTypeMapper.mapType(fieldType.physicalType()).orElse(UNKNOWN_TYPE);
        return MappedFieldTypeDTO.create(fieldType.fieldName(), mappedFieldType);
    }

    private Set<MappedFieldTypeDTO> mergeCompoundFieldTypes(Stream<MappedFieldTypeDTO> stream) {
        return stream.collect(Collectors.groupingBy(MappedFieldTypeDTO::name, Collectors.toSet())).entrySet().stream().map(entry -> {
            Set fieldTypes = (Set)entry.getValue();
            String fieldName = (String)entry.getKey();
            if (fieldTypes.size() == 1) {
                return (MappedFieldTypeDTO)fieldTypes.iterator().next();
            }
            Set distinctTypes = fieldTypes.stream().map(mappedFieldTypeDTO -> mappedFieldTypeDTO.type().type()).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
            String compoundFieldType = distinctTypes.size() > 1 ? distinctTypes.stream().collect(Collectors.joining(",", "compound(", ")")) : distinctTypes.stream().findFirst().orElse("unknown");
            ImmutableSet commonProperties = fieldTypes.stream().map(mappedFieldTypeDTO -> mappedFieldTypeDTO.type().properties()).reduce((s1, s2) -> Sets.intersection((Set)s1, (Set)s2).immutableCopy()).orElse(ImmutableSet.of());
            ImmutableSet properties = ImmutableSet.builder().addAll((Iterable)commonProperties).add((Object)PROP_COMPOUND_TYPE).build();
            return MappedFieldTypeDTO.create(fieldName, FieldTypes.Type.createType(compoundFieldType, (Set<String>)properties));
        }).collect(Collectors.toSet());
    }
}

