/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.messages;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import javax.inject.Inject;

public class TrafficAccounting {
    private final Counter outputByteCounter;
    private final Counter systemTrafficCounter;

    @Inject
    public TrafficAccounting(MetricRegistry metricRegistry) {
        this.outputByteCounter = metricRegistry.counter("org.graylog2.traffic.output");
        this.systemTrafficCounter = metricRegistry.counter("org.graylog2.traffic.system-output-traffic");
    }

    public void addOutputTraffic(long size) {
        this.outputByteCounter.inc(size);
    }

    public void addSystemTraffic(long size) {
        this.systemTrafficCounter.inc(size);
    }
}

