/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.converters;

import com.google.common.base.Strings;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.graylog2.ConfigurationException;
import org.graylog2.inputs.converters.AbstractDateConverter;
import org.graylog2.plugin.inputs.Converter;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.YearMonth;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateConverter
extends AbstractDateConverter {
    private static final Logger LOG = LoggerFactory.getLogger(DateConverter.class);
    private static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private final String dateFormat;
    private final Locale locale;
    private final boolean containsTimeZone;

    public DateConverter(Map<String, Object> config) throws ConfigurationException {
        super(Converter.Type.DATE, config);
        if (config.get("date_format") == null || ((String)config.get("date_format")).isEmpty()) {
            throw new ConfigurationException("Missing config [date_format].");
        }
        this.dateFormat = ((String)config.get("date_format")).trim();
        this.locale = DateConverter.buildLocale(config.get("locale"));
        this.containsTimeZone = this.dateFormat.contains("Z") || this.dateFormat.contains("z");
    }

    private static Locale buildLocale(Object languageTag) {
        if (languageTag instanceof String) {
            try {
                return Locale.forLanguageTag((String)languageTag);
            }
            catch (IllegalArgumentException e) {
                return DEFAULT_LOCALE;
            }
        }
        return DEFAULT_LOCALE;
    }

    @Override
    @Nullable
    public Object convert(@Nullable String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        LOG.debug("Trying to parse date <{}> with pattern <{}>, locale <{}>, and timezone <{}>.", new Object[]{value, this.dateFormat, this.locale, this.timeZone});
        DateTimeFormatter formatter = this.containsTimeZone ? DateTimeFormat.forPattern((String)this.dateFormat).withDefaultYear(YearMonth.now((DateTimeZone)this.timeZone).getYear()).withLocale(this.locale) : DateTimeFormat.forPattern((String)this.dateFormat).withDefaultYear(YearMonth.now((DateTimeZone)this.timeZone).getYear()).withLocale(this.locale).withZone(this.timeZone);
        return DateTime.parse((String)value, (DateTimeFormatter)formatter);
    }
}

