/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.transports.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.ReadTimeoutException;
import org.graylog2.plugin.inputs.MessageInput;
import org.slf4j.Logger;

public class ExceptionLoggingChannelHandler
extends ChannelInboundHandlerAdapter {
    private final MessageInput input;
    private final Logger logger;
    private final boolean keepAliveEnabled;

    public ExceptionLoggingChannelHandler(MessageInput input, Logger logger) {
        this(input, logger, false);
    }

    public ExceptionLoggingChannelHandler(MessageInput input, Logger logger, boolean keepAliveEnabled) {
        this.input = input;
        this.logger = logger;
        this.keepAliveEnabled = keepAliveEnabled;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.logger.isTraceEnabled() && "Connection reset by peer".equals(cause.getMessage())) {
            this.logger.trace("{} in Input [{}/{}] (channel {})", new Object[]{cause.getMessage(), this.input.getName(), this.input.getId(), ctx.channel()});
        } else if (this.keepAliveEnabled && cause instanceof ReadTimeoutException) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("KeepAlive Timeout in input [{}/{}] (channel {})", new Object[]{this.input.getName(), this.input.getId(), ctx.channel()});
            }
        } else {
            this.logger.error("Error in Input [{}/{}] (channel {}) (cause {})", new Object[]{this.input.getName(), this.input.getId(), ctx.channel(), cause});
        }
        ctx.close();
    }
}

