/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.Collections;
import javax.inject.Inject;
import org.graylog2.contentpacks.ContentPackPersistenceService;
import org.graylog2.contentpacks.ContentPackService;
import org.graylog2.contentpacks.exceptions.ContentPackException;
import org.graylog2.contentpacks.model.ContentPack;
import org.graylog2.migrations.AutoValue_V20180924111644_AddDefaultGrokPatterns_MigrationCompleted;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20180924111644_AddDefaultGrokPatterns
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20180924111644_AddDefaultGrokPatterns.class);
    private final ContentPackService contentPackService;
    private final ObjectMapper objectMapper;
    private final ClusterConfigService configService;
    private final ContentPackPersistenceService contentPackPersistenceService;

    @Inject
    public V20180924111644_AddDefaultGrokPatterns(ContentPackPersistenceService contentPackPersistenceService, ContentPackService contentPackService, ObjectMapper objectMapper, ClusterConfigService clusterConfigService) {
        this.contentPackService = contentPackService;
        this.objectMapper = objectMapper;
        this.contentPackPersistenceService = contentPackPersistenceService;
        this.configService = clusterConfigService;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2018-09-24T11:16:44Z");
    }

    @Override
    public void upgrade() {
        if (this.configService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already completed.");
            return;
        }
        try {
            URL contentPackURL = V20180924111644_AddDefaultGrokPatterns.class.getResource("V20180924111644_AddDefaultGrokPatterns_Default_Grok_Patterns.json");
            ContentPack contentPack = (ContentPack)this.objectMapper.readValue(contentPackURL, ContentPack.class);
            ContentPack pack = this.contentPackPersistenceService.insert(contentPack).orElseThrow(() -> {
                this.configService.write(MigrationCompleted.create(contentPack.id().toString()));
                return new ContentPackException("Content pack " + contentPack.id() + " with this revision " + contentPack.revision() + " already found!");
            });
            try {
                this.contentPackService.installContentPack(pack, Collections.emptyMap(), "Add default Grok patterns", "admin");
            }
            catch (ContentPackException e) {
                LOG.warn("Could not install default grok patterns: the installation found some modified default grokpatterns in your setup and did not update them. If you wish to use the default grokpatterns we provide, please delete the modified grok pattern and install the 'Default grokpatterns' content pack manually.");
            }
            this.configService.write(MigrationCompleted.create(pack.id().toString()));
        }
        catch (IOException e) {
            LOG.error("Unable to import content pack for default grok patterns: {}", (Throwable)e);
        }
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class MigrationCompleted {
        @JsonProperty(value="content_pack_id")
        public abstract String contentPackId();

        @JsonCreator
        public static MigrationCompleted create(@JsonProperty(value="content_pack_id") String contentPackId) {
            return new AutoValue_V20180924111644_AddDefaultGrokPatterns_MigrationCompleted(contentPackId);
        }
    }
}

