/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Sorts;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.graylog.security.authservice.AuthServiceBackendDTO;
import org.graylog.security.authservice.DBAuthServiceBackendService;
import org.graylog.security.authservice.backend.ADAuthServiceBackendConfig;
import org.graylog.security.authservice.backend.LDAPAuthServiceBackendConfig;
import org.graylog.security.authservice.ldap.LDAPTransportSecurity;
import org.graylog.security.authzroles.AuthzRoleDTO;
import org.graylog.security.authzroles.PaginatedAuthzRolesService;
import org.graylog2.Configuration;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.AutoValue_V20201103145400_LegacyAuthServiceMigration_MigrationCompleted;
import org.graylog2.migrations.Migration;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.security.AESTools;
import org.graylog2.security.encryption.EncryptedValue;
import org.graylog2.security.encryption.EncryptedValueService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20201103145400_LegacyAuthServiceMigration
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20201103145400_LegacyAuthServiceMigration.class);
    private final MongoCollection<Document> ldapSettings;
    private final Set<MigrationModule> migrationModules;
    private final EncryptedValueService encryptedValueService;
    private final PaginatedAuthzRolesService rolesService;
    private final DBAuthServiceBackendService authServiceBackendService;
    private final NotificationService notificationService;
    private final ClusterConfigService clusterConfigService;
    private final String encryptionKey;

    @Inject
    public V20201103145400_LegacyAuthServiceMigration(MongoConnection mongoConnection, Set<MigrationModule> migrationModules, EncryptedValueService encryptedValueService, Configuration configuration, PaginatedAuthzRolesService rolesService, DBAuthServiceBackendService authServiceBackendService, NotificationService notificationService, ClusterConfigService clusterConfigService) {
        this.ldapSettings = mongoConnection.getMongoDatabase().getCollection("ldap_settings");
        this.migrationModules = migrationModules;
        this.encryptedValueService = encryptedValueService;
        this.encryptionKey = configuration.getPasswordSecret().substring(0, 16);
        this.rolesService = rolesService;
        this.authServiceBackendService = authServiceBackendService;
        this.notificationService = notificationService;
        this.clusterConfigService = clusterConfigService;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2020-11-03T14:54:00Z");
    }

    @Override
    public void upgrade() {
        MigrationCompleted migrationState = this.clusterConfigService.getOrDefault(MigrationCompleted.class, MigrationCompleted.createEmpty());
        ImmutableSet.Builder migratedConfigsBuilder = ImmutableSet.builder();
        String lastCreatedAuthServiceId = null;
        migratedConfigsBuilder.addAll(migrationState.migratedConfigs());
        for (Document document : this.ldapSettings.find().sort(Sorts.ascending((String[])new String[]{"_id"}))) {
            String idString = document.getObjectId((Object)"_id").toHexString();
            if (!document.getBoolean((Object)"enabled").booleanValue()) {
                LOG.debug("Skipping disabled configuration <{}>", (Object)idString);
                continue;
            }
            if (migrationState.isDone(idString)) {
                LOG.debug("Configuration <{}> already migrated", (Object)idString);
                continue;
            }
            AuthServiceBackendDTO newConfig = document.getBoolean((Object)"active_directory") != false ? this.buildActiveDirectoryConfig(document) : this.buildLDAPConfig(document);
            AuthServiceBackendDTO savedConfig = this.authServiceBackendService.save(newConfig);
            for (MigrationModule migrationModule : this.migrationModules) {
                migrationModule.upgrade(document, savedConfig);
            }
            lastCreatedAuthServiceId = savedConfig.id();
            migratedConfigsBuilder.add((Object)idString);
        }
        ImmutableSet migratedConfigs = migratedConfigsBuilder.build();
        this.clusterConfigService.write(MigrationCompleted.create((Set<String>)migratedConfigs));
        if (lastCreatedAuthServiceId != null) {
            Notification notification = this.notificationService.buildNow().addType(Notification.Type.LEGACY_LDAP_CONFIG_MIGRATION).addSeverity(Notification.Severity.URGENT).addDetail("auth_service_id", lastCreatedAuthServiceId);
            this.notificationService.publishIfFirst(notification);
        }
    }

    private AuthServiceBackendDTO buildActiveDirectoryConfig(Document document) {
        return AuthServiceBackendDTO.builder().title(this.getTitle(document, "Active Directory")).description("Migrated from legacy Active Directory configuration.").defaultRoles(this.getDefaultRoles(document)).config(ADAuthServiceBackendConfig.builder().servers(Collections.singletonList(this.getADHostAndPort(document))).transportSecurity(this.getTransportSecurity(document)).verifyCertificates(this.getVerifyCertificates(document)).systemUserDn(document.getString((Object)"system_username")).systemUserPassword(this.getSystemUserPassword(document)).userSearchBase(document.getString((Object)"search_base")).userSearchPattern(document.getString((Object)"principal_search_pattern")).userNameAttribute("sAMAccountName").userFullNameAttribute(document.getString((Object)"username_attribute")).build()).build();
    }

    private AuthServiceBackendDTO buildLDAPConfig(Document document) {
        return AuthServiceBackendDTO.builder().title(this.getTitle(document, "LDAP")).description("Migrated from legacy LDAP configuration.").defaultRoles(this.getDefaultRoles(document)).config(LDAPAuthServiceBackendConfig.builder().servers(Collections.singletonList(this.getLDAPHostAndPort(document))).transportSecurity(this.getTransportSecurity(document)).verifyCertificates(this.getVerifyCertificates(document)).systemUserDn(document.getString((Object)"system_username")).systemUserPassword(this.getSystemUserPassword(document)).userSearchBase(document.getString((Object)"search_base")).userSearchPattern(document.getString((Object)"principal_search_pattern")).userUniqueIdAttribute("entryUUID").userNameAttribute("uid").userFullNameAttribute(document.getString((Object)"username_attribute")).build()).build();
    }

    private String getTitle(Document document, String prefix) {
        String ldapUriString = document.getString((Object)"ldap_uri");
        return String.format(Locale.US, "%s- %s", prefix, ldapUriString);
    }

    private LDAPAuthServiceBackendConfig.HostAndPort getLDAPHostAndPort(Document document) {
        String ldapUriString = document.getString((Object)"ldap_uri");
        URI ldapUri = URI.create(ldapUriString);
        return LDAPAuthServiceBackendConfig.HostAndPort.create(ldapUri.getHost(), ldapUri.getPort());
    }

    private ADAuthServiceBackendConfig.HostAndPort getADHostAndPort(Document document) {
        String ldapUriString = document.getString((Object)"ldap_uri");
        URI ldapUri = URI.create(ldapUriString);
        return ADAuthServiceBackendConfig.HostAndPort.create(ldapUri.getHost(), ldapUri.getPort());
    }

    private LDAPTransportSecurity getTransportSecurity(Document document) {
        String ldapUriString = document.getString((Object)"ldap_uri");
        Boolean isStartTLS = document.getBoolean((Object)"use_start_tls");
        if (isStartTLS.booleanValue()) {
            return LDAPTransportSecurity.START_TLS;
        }
        if (ldapUriString.toLowerCase(Locale.US).startsWith("ldaps://")) {
            return LDAPTransportSecurity.TLS;
        }
        return LDAPTransportSecurity.NONE;
    }

    private boolean getVerifyCertificates(Document document) {
        return !document.getBoolean((Object)"trust_all_certificates", false);
    }

    private EncryptedValue getSystemUserPassword(Document document) {
        String encryptedPassword = document.getString((Object)"system_password");
        String salt = document.getString((Object)"system_password_salt");
        if (StringUtils.isNotBlank((CharSequence)encryptedPassword) && StringUtils.isNotBlank((CharSequence)salt)) {
            return this.encryptedValueService.encrypt(AESTools.decrypt(encryptedPassword, this.encryptionKey, salt));
        }
        return EncryptedValue.createUnset();
    }

    private Set<String> getDefaultRoles(Document document) {
        String defaultRole = document.getString((Object)"default_group");
        List additionalDefaultRoles = document.getList((Object)"additional_default_groups", String.class, Collections.emptyList());
        Set<String> roleIds = Stream.concat(Stream.of(defaultRole), additionalDefaultRoles.stream()).filter(StringUtils::isNotBlank).filter(ObjectId::isValid).collect(Collectors.toSet());
        return this.rolesService.findByIds(roleIds).stream().map(AuthzRoleDTO::id).collect(Collectors.toSet());
    }

    @AutoValue
    public static abstract class MigrationCompleted {
        @JsonProperty(value="migrated_configs")
        public abstract Set<String> migratedConfigs();

        public boolean isDone(String id) {
            return this.migratedConfigs().contains(id);
        }

        @JsonCreator
        public static MigrationCompleted create(@JsonProperty(value="migrated_configs") Set<String> migratedConfigs) {
            return new AutoValue_V20201103145400_LegacyAuthServiceMigration_MigrationCompleted(migratedConfigs);
        }

        public static MigrationCompleted createEmpty() {
            return MigrationCompleted.create(Collections.emptySet());
        }
    }

    public static interface MigrationModule {
        public void upgrade(Document var1, AuthServiceBackendDTO var2);
    }
}

