/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin;

import com.codahale.metrics.Meter;
import com.eaio.uuid.UUID;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.graylog.failure.FailureCause;
import org.graylog.failure.ProcessingFailureCause;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.messages.Indexable;
import org.graylog2.plugin.Messages;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.plugin.utilities.date.DateTimeConverter;
import org.graylog2.shared.utilities.ExceptionUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class Message
implements Messages,
Indexable {
    private static final Logger LOG = LoggerFactory.getLogger(Message.class);
    public static final String FIELD_ID = "_id";
    public static final String FIELD_MESSAGE = "message";
    public static final String FIELD_FULL_MESSAGE = "full_message";
    public static final String FIELD_SOURCE = "source";
    public static final String FIELD_TIMESTAMP = "timestamp";
    public static final String FIELD_LEVEL = "level";
    public static final String FIELD_STREAMS = "streams";
    public static final String INTERNAL_FIELD_PREFIX = "gl2_";
    public static final String FIELD_GL2_ACCOUNTED_MESSAGE_SIZE = "gl2_accounted_message_size";
    public static final String FIELD_GL2_MESSAGE_ID = "gl2_message_id";
    public static final String FIELD_GL2_PROCESSING_ERROR = "gl2_processing_error";
    public static final String FIELD_GL2_PROCESSING_TIMESTAMP = "gl2_processing_timestamp";
    public static final String FIELD_GL2_RECEIVE_TIMESTAMP = "gl2_receive_timestamp";
    public static final String FIELD_GL2_REMOTE_HOSTNAME = "gl2_remote_hostname";
    public static final String FIELD_GL2_REMOTE_IP = "gl2_remote_ip";
    public static final String FIELD_GL2_REMOTE_PORT = "gl2_remote_port";
    public static final String FIELD_GL2_SOURCE_COLLECTOR = "gl2_source_collector";
    @Deprecated
    public static final String FIELD_GL2_SOURCE_COLLECTOR_INPUT = "gl2_source_collector_input";
    public static final String FIELD_GL2_SOURCE_INPUT = "gl2_source_input";
    public static final String FIELD_GL2_SOURCE_NODE = "gl2_source_node";
    @Deprecated
    public static final String FIELD_GL2_SOURCE_RADIO = "gl2_source_radio";
    @Deprecated
    public static final String FIELD_GL2_SOURCE_RADIO_INPUT = "gl2_source_radio_input";
    private static final Pattern VALID_KEY_CHARS = Pattern.compile("^[\\w\\.\\-@]*$");
    private static final char KEY_REPLACEMENT_CHAR = '_';
    private static final ImmutableSet<String> GRAYLOG_FIELDS = ImmutableSet.of((Object)"gl2_accounted_message_size", (Object)"gl2_processing_error", (Object)"gl2_processing_timestamp", (Object)"gl2_receive_timestamp", (Object)"gl2_remote_hostname", (Object)"gl2_remote_ip", (Object[])new String[]{"gl2_remote_port", "gl2_source_collector", "gl2_source_collector_input", "gl2_source_input", "gl2_source_node", "gl2_source_radio", "gl2_source_radio_input"});
    private static final Set<String> ILLUMINATE_FIELDS = ImmutableSet.of((Object)"gl2_event_category", (Object)"gl2_event_subcategory", (Object)"gl2_event_type", (Object)"gl2_event_type_code", (Object)"gl2_tags", (Object)"gim_event_class", (Object[])new String[]{"gim_event_category", "gim_event_type", "gim_event_type_code", "gim_tags", "gim_version"});
    private static final ImmutableSet<String> CORE_MESSAGE_FIELDS = ImmutableSet.of((Object)"message", (Object)"source", (Object)"timestamp");
    private static final ImmutableSet<String> ES_FIELDS = ImmutableSet.of((Object)"_id", (Object)"_ttl", (Object)"_source", (Object)"_all", (Object)"_index", (Object)"_type", (Object[])new String[]{"_score"});
    public static final ImmutableSet<String> RESERVED_SETTABLE_FIELDS = new ImmutableSet.Builder().addAll(GRAYLOG_FIELDS).addAll(CORE_MESSAGE_FIELDS).build();
    public static final ImmutableSet<String> RESERVED_FIELDS = new ImmutableSet.Builder().addAll(RESERVED_SETTABLE_FIELDS).addAll(ES_FIELDS).build();
    public static final ImmutableSet<String> FILTERED_FIELDS = new ImmutableSet.Builder().addAll(GRAYLOG_FIELDS).addAll(ES_FIELDS).add((Object)"streams").add((Object)"full_message").build();
    private static final ImmutableSet<String> REQUIRED_FIELDS = ImmutableSet.of((Object)"message", (Object)"_id");
    @Deprecated
    public static final Function<Message, String> ID_FUNCTION = new MessageIdFunction();
    private final Map<String, Object> fields = Maps.newHashMap();
    private Set<Stream> streams = Sets.newHashSet();
    private Set<IndexSet> indexSets = Sets.newHashSet();
    private String sourceInputId;
    private boolean filterOut = false;
    private Object messageQueueId;
    private DateTime receiveTime;
    private DateTime processingTime;
    private ArrayList<Recording> recordings;
    private Map<String, Object> metadata;
    private com.codahale.metrics.Counter sizeCounter = new com.codahale.metrics.Counter();
    private List<ProcessingError> processingErrors;
    private static final IdentityHashMap<Class<?>, Integer> classSizes = Maps.newIdentityHashMap();

    public Message(String message, String source, DateTime timestamp) {
        this.fields.put(FIELD_ID, new UUID().toString());
        this.addRequiredField(FIELD_MESSAGE, message);
        this.addRequiredField(FIELD_SOURCE, source);
        this.addRequiredField(FIELD_TIMESTAMP, timestamp);
    }

    public Message(Map<String, Object> fields) {
        this((String)fields.get(FIELD_ID), Maps.filterKeys(fields, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)FIELD_ID))));
    }

    private Message(String id, Map<String, Object> newFields) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"message id cannot be null");
        this.fields.put(FIELD_ID, id);
        this.addFields(newFields);
    }

    public boolean isComplete() {
        for (String key : REQUIRED_FIELDS) {
            Object field = this.getField(key);
            if (field != null && (!(field instanceof String) || !((String)field).isEmpty())) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Message <{}> is incomplete because the field <{}> is <{}>", new Object[]{this.fields.get(FIELD_ID), key, field});
            }
            return false;
        }
        return true;
    }

    @Deprecated
    public String getValidationErrors() {
        StringBuilder sb = new StringBuilder();
        for (String key : REQUIRED_FIELDS) {
            Object field = this.getField(key);
            if (field == null) {
                sb.append(key).append(" is missing, ");
                continue;
            }
            if (!(field instanceof String) || !((String)field).isEmpty()) continue;
            sb.append(key).append(" is empty, ");
        }
        return sb.toString();
    }

    @Override
    public String getId() {
        return this.getFieldAs(String.class, FIELD_ID);
    }

    @Override
    public String getMessageId() {
        return this.getFieldAs(String.class, FIELD_GL2_MESSAGE_ID);
    }

    @Override
    public DateTime getTimestamp() {
        return this.getFieldAs(DateTime.class, FIELD_TIMESTAMP).withZone(DateTimeZone.UTC);
    }

    @Override
    public Map<String, Object> toElasticSearchObject(ObjectMapper objectMapper, @Nonnull Meter invalidTimestampMeter) {
        HashMap obj = Maps.newHashMapWithExpectedSize((int)(REQUIRED_FIELDS.size() + this.fields.size()));
        for (Map.Entry<String, Object> entry : this.fields.entrySet()) {
            String newKey;
            String key = entry.getKey();
            if (key.equals(FIELD_ID)) continue;
            Object value = entry.getValue();
            if (key.contains(".")) {
                newKey = key.replace('.', '_');
                if (!obj.containsKey(newKey)) {
                    obj.put(newKey, value);
                    continue;
                }
                LOG.warn("Keys must not contain a \".\" character! Ignoring field \"{}\"=\"{}\" in message [{}] - Unable to replace \".\" with a \"{}\" because of key conflict: \"{}\"=\"{}\"", new Object[]{key, value, this.getId(), Character.valueOf('_'), newKey, obj.get(newKey)});
                LOG.debug("Full message with \".\" in message key: {}", (Object)this);
                continue;
            }
            if (obj.containsKey(key)) {
                newKey = key.replace('_', '.');
                LOG.warn("Keys must not contain a \".\" character! Ignoring field \"{}\"=\"{}\" in message [{}] - Unable to replace \".\" with a \"{}\" because of key conflict: \"{}\"=\"{}\"", new Object[]{newKey, this.fields.get(newKey), this.getId(), Character.valueOf('_'), key, value});
                LOG.debug("Full message with \".\" in message key: {}", (Object)this);
            }
            obj.put(key, value);
        }
        obj.put(FIELD_MESSAGE, this.getMessage());
        obj.put(FIELD_SOURCE, this.getSource());
        obj.put(FIELD_STREAMS, this.getStreamIds());
        obj.put(FIELD_GL2_ACCOUNTED_MESSAGE_SIZE, this.getSize());
        Object timestampValue = this.getField(FIELD_TIMESTAMP);
        DateTime dateTime = timestampValue == null ? this.fallbackForNullTimestamp() : this.convertToDateTime(timestampValue);
        obj.put(FIELD_TIMESTAMP, Tools.buildElasticSearchTimeFormat(dateTime.withZone(DateTimeZone.UTC)));
        if (this.processingErrors != null && !this.processingErrors.isEmpty()) {
            if (this.processingErrors.stream().anyMatch(processingError -> processingError.getCause().equals(ProcessingFailureCause.InvalidTimestampException))) {
                invalidTimestampMeter.mark();
            }
            obj.put(FIELD_GL2_PROCESSING_ERROR, this.processingErrors.stream().map(ProcessingError::getDetails).collect(Collectors.joining(", ")));
        }
        return obj;
    }

    private DateTime convertToDateTime(@Nonnull Object value) {
        try {
            return DateTimeConverter.convertToDateTime(value);
        }
        catch (IllegalArgumentException e) {
            String error = "Invalid value for field timestamp in message <" + this.getId() + ">, forcing to current time.";
            LOG.trace("{}: {}", (Object)error, (Object)e);
            this.addProcessingError(new ProcessingError(ProcessingFailureCause.InvalidTimestampException, "Replaced invalid timestamp value in message <" + this.getId() + "> with current time", "Value <" + value + "> caused exception: " + ExceptionUtils.getRootCauseMessage(e)));
            return Tools.nowUTC();
        }
    }

    private DateTime fallbackForNullTimestamp() {
        String error = "<null> value for field timestamp in message <" + this.getId() + ">, forcing to current time";
        LOG.trace(error);
        this.addProcessingError(new ProcessingError(ProcessingFailureCause.InvalidTimestampException, "Replaced invalid timestamp value in message <" + this.getId() + "> with current time", "<null> value provided"));
        return Tools.nowUTC();
    }

    static long sizeForField(@Nonnull String key, @Nonnull Object value) {
        return (long)key.length() + Message.sizeForValue(value);
    }

    public String toString() {
        return this.toString(true);
    }

    public String toDumpString() {
        return this.toString(false);
    }

    private String toString(boolean truncate) {
        StringBuilder sb = new StringBuilder();
        sb.append("source: ").append(this.getField(FIELD_SOURCE)).append(" | ");
        String message = this.getField(FIELD_MESSAGE).toString().replaceAll("\\n", "").replaceAll("\\t", "");
        sb.append("message: ");
        if (truncate && message.length() > 225) {
            sb.append(message.substring(0, 225)).append(" (...)");
        } else {
            sb.append(message);
        }
        sb.append(" { ");
        HashMap filteredFields = Maps.newHashMap(this.fields);
        filteredFields.remove(FIELD_SOURCE);
        filteredFields.remove(FIELD_MESSAGE);
        Joiner.on((String)" | ").withKeyValueSeparator(": ").appendTo(sb, (Map)filteredFields);
        sb.append(" }");
        return sb.toString();
    }

    public String getMessage() {
        return this.getFieldAs(String.class, FIELD_MESSAGE);
    }

    public String getSource() {
        return this.getFieldAs(String.class, FIELD_SOURCE);
    }

    public void setSource(String source) {
        Object previousSource = this.fields.put(FIELD_SOURCE, source);
        this.updateSize(FIELD_SOURCE, source, previousSource);
    }

    public void addField(String key, Object value) {
        this.addField(key, value, false);
    }

    private void addRequiredField(String key, Object value) {
        this.addField(key, value, true);
    }

    private void addField(String key, Object value, boolean isRequiredField) {
        String trimmedKey = key.trim();
        if (RESERVED_FIELDS.contains((Object)trimmedKey) && !RESERVED_SETTABLE_FIELDS.contains((Object)trimmedKey) || !Message.validKey(trimmedKey)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring invalid or reserved key {} for message {}", (Object)trimmedKey, (Object)this.getId());
            }
            return;
        }
        boolean isTimestamp = FIELD_TIMESTAMP.equals(trimmedKey);
        if (isTimestamp) {
            DateTime timeStamp = value == null ? this.fallbackForNullTimestamp() : this.convertToDateTime(value);
            Object previousValue = this.fields.put(FIELD_TIMESTAMP, timeStamp);
            this.updateSize(trimmedKey, timeStamp, previousValue);
        } else if (value instanceof String) {
            String str = ((String)value).trim();
            if (isRequiredField || !str.isEmpty()) {
                Object previousValue = this.fields.put(trimmedKey, str);
                this.updateSize(trimmedKey, str, previousValue);
            }
        } else if (value != null) {
            Object previousValue = this.fields.put(trimmedKey, value);
            this.updateSize(trimmedKey, value, previousValue);
        }
    }

    private void updateSize(String fieldName, Object newValue, Object previousValue) {
        if (GRAYLOG_FIELDS.contains((Object)fieldName) || ILLUMINATE_FIELDS.contains(fieldName)) {
            return;
        }
        long newValueSize = 0L;
        long oldValueSize = 0L;
        long oldSize = this.sizeCounter.getCount();
        int keyLength = fieldName.length();
        if (newValue == null) {
            this.sizeCounter.dec((long)keyLength);
        } else {
            newValueSize = Message.sizeForValue(newValue);
            this.sizeCounter.inc(newValueSize);
        }
        if (previousValue == null) {
            this.sizeCounter.inc((long)keyLength);
        } else {
            oldValueSize = Message.sizeForValue(previousValue);
            this.sizeCounter.dec(oldValueSize);
        }
        if (LOG.isTraceEnabled()) {
            long newSize = this.sizeCounter.getCount();
            LOG.trace("[Message size update][{}] key {}/{}, new/old/change: {}/{}/{} total: {}", new Object[]{this.getId(), fieldName, keyLength, newValueSize, oldValueSize, newSize - oldSize, newSize});
        }
    }

    static long sizeForValue(@Nonnull Object value) {
        Integer classSize;
        long valueSize = value instanceof CharSequence ? (long)((CharSequence)value).length() : ((classSize = classSizes.get(value.getClass())) == null ? 0L : (long)classSize.intValue());
        return valueSize;
    }

    @Override
    public long getSize() {
        return this.sizeCounter.getCount();
    }

    public static boolean validKey(String key) {
        return VALID_KEY_CHARS.matcher(key).matches();
    }

    public void addFields(Map<String, Object> fields) {
        if (fields == null) {
            return;
        }
        for (Map.Entry<String, Object> field : fields.entrySet()) {
            this.addField(field.getKey(), field.getValue());
        }
    }

    @Deprecated
    public void addStringFields(Map<String, String> fields) {
        if (fields == null) {
            return;
        }
        for (Map.Entry<String, String> field : fields.entrySet()) {
            this.addField(field.getKey(), field.getValue());
        }
    }

    @Deprecated
    public void addLongFields(Map<String, Long> fields) {
        if (fields == null) {
            return;
        }
        for (Map.Entry<String, Long> field : fields.entrySet()) {
            this.addField(field.getKey(), field.getValue());
        }
    }

    @Deprecated
    public void addDoubleFields(Map<String, Double> fields) {
        if (fields == null) {
            return;
        }
        for (Map.Entry<String, Double> field : fields.entrySet()) {
            this.addField(field.getKey(), field.getValue());
        }
    }

    public void removeField(String key) {
        if (!RESERVED_FIELDS.contains((Object)key)) {
            Object removedValue = this.fields.remove(key);
            this.updateSize(key, null, removedValue);
        }
    }

    public <T> T getFieldAs(Class<T> T, String key) throws ClassCastException {
        return T.cast(this.getField(key));
    }

    public Object getField(String key) {
        return this.fields.get(key);
    }

    public Map<String, Object> getFields() {
        return ImmutableMap.copyOf(this.fields);
    }

    public Iterable<Map.Entry<String, Object>> getFieldsEntries() {
        return Iterables.unmodifiableIterable(this.fields.entrySet());
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public boolean hasField(String field) {
        return this.fields.containsKey(field);
    }

    public Set<String> getFieldNames() {
        return Collections.unmodifiableSet(this.fields.keySet());
    }

    @Deprecated
    public void setStreams(List<Stream> streams) {
        this.streams = Sets.newHashSet(streams);
    }

    public Set<Stream> getStreams() {
        return ImmutableSet.copyOf(this.streams);
    }

    public void addStream(Stream stream) {
        this.indexSets.add(stream.getIndexSet());
        if (this.streams.add(stream)) {
            this.sizeCounter.inc(8L);
            if (LOG.isTraceEnabled()) {
                LOG.trace("[Message size update][{}] stream added: {}", (Object)this.getId(), (Object)this.sizeCounter.getCount());
            }
        }
    }

    public void addStreams(Iterable<Stream> newStreams) {
        for (Stream stream : newStreams) {
            this.addStream(stream);
        }
    }

    public boolean removeStream(Stream stream) {
        boolean removed = this.streams.remove(stream);
        if (removed) {
            this.indexSets.clear();
            for (Stream s : this.streams) {
                this.indexSets.add(s.getIndexSet());
            }
            this.sizeCounter.dec(8L);
            if (LOG.isTraceEnabled()) {
                LOG.trace("[Message size update][{}] stream removed: {}", (Object)this.getId(), (Object)this.sizeCounter.getCount());
            }
        }
        return removed;
    }

    public Set<IndexSet> getIndexSets() {
        return ImmutableSet.copyOf(this.indexSets);
    }

    public Collection<String> getStreamIds() {
        Set streamField;
        try {
            streamField = this.getFieldAs(Collection.class, FIELD_STREAMS);
        }
        catch (ClassCastException e) {
            LOG.trace("Couldn't cast {} to List", (Object)FIELD_STREAMS, (Object)e);
            streamField = Collections.emptySet();
        }
        HashSet<String> streamIds = streamField == null ? new HashSet<String>(this.streams.size()) : new HashSet(streamField);
        for (Stream stream : this.streams) {
            streamIds.add(stream.getId());
        }
        return streamIds;
    }

    public void setFilterOut(boolean filterOut) {
        this.filterOut = filterOut;
    }

    public boolean getFilterOut() {
        return this.filterOut;
    }

    public void setSourceInputId(String sourceInputId) {
        this.sourceInputId = sourceInputId;
    }

    public String getSourceInputId() {
        return this.sourceInputId;
    }

    @Deprecated
    public boolean getIsSourceInetAddress() {
        return this.fields.containsKey(FIELD_GL2_REMOTE_IP);
    }

    public InetAddress getInetAddress() {
        if (!this.fields.containsKey(FIELD_GL2_REMOTE_IP)) {
            return null;
        }
        String ipAddr = (String)this.fields.get(FIELD_GL2_REMOTE_IP);
        try {
            return InetAddresses.forString((String)ipAddr);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    public void setJournalOffset(long journalOffset) {
        this.messageQueueId = journalOffset;
    }

    @Deprecated
    public long getJournalOffset() {
        if (this.messageQueueId == null) {
            return Long.MIN_VALUE;
        }
        return (Long)this.messageQueueId;
    }

    public void setMessageQueueId(Object messageQueueId) {
        this.messageQueueId = messageQueueId;
    }

    @Nullable
    public Object getMessageQueueId() {
        return this.messageQueueId;
    }

    @Override
    @Nullable
    public DateTime getReceiveTime() {
        return this.receiveTime;
    }

    public void setReceiveTime(DateTime receiveTime) {
        if (receiveTime != null) {
            this.receiveTime = receiveTime;
        }
    }

    @Nullable
    public DateTime getProcessingTime() {
        return this.processingTime;
    }

    public void setProcessingTime(DateTime processingTime) {
        if (processingTime != null) {
            this.processingTime = processingTime;
        }
    }

    public void recordTiming(ServerStatus serverStatus, String name, long elapsedNanos) {
        if (this.shouldNotRecord(serverStatus)) {
            return;
        }
        this.lazyInitRecordings();
        this.recordings.add(Recording.timing(name, elapsedNanos));
    }

    public void recordCounter(ServerStatus serverStatus, String name, int counter) {
        if (this.shouldNotRecord(serverStatus)) {
            return;
        }
        this.lazyInitRecordings();
        this.recordings.add(Recording.counter(name, counter));
    }

    public String recordingsAsString() {
        if (this.hasRecordings()) {
            return Joiner.on((String)", ").join(this.recordings);
        }
        return "";
    }

    public boolean hasRecordings() {
        return this.recordings != null && this.recordings.size() > 0;
    }

    private void lazyInitRecordings() {
        if (this.recordings == null) {
            this.recordings = new ArrayList();
        }
    }

    private boolean shouldNotRecord(ServerStatus serverStatus) {
        return !serverStatus.getDetailedMessageRecordingStrategy().shouldRecord(this);
    }

    public void addProcessingError(@Nonnull ProcessingError processingError) {
        if (this.processingErrors == null) {
            this.processingErrors = new ArrayList<ProcessingError>();
        }
        this.processingErrors.add(processingError);
    }

    public List<ProcessingError> processingErrors() {
        if (this.processingErrors == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(this.processingErrors);
    }

    @Override
    @Nonnull
    public Iterator<Message> iterator() {
        if (this.getFilterOut()) {
            return Collections.emptyIterator();
        }
        return Iterators.singletonIterator((Object)this);
    }

    @Override
    public boolean supportsFailureHandling() {
        return true;
    }

    public void setMetadata(String key, Object value) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)key), (Object)"A non-empty key is required.");
        Preconditions.checkNotNull((Object)value);
        if (this.metadata == null) {
            this.metadata = new HashMap<String, Object>();
        }
        this.metadata.put(key, value);
    }

    @Nullable
    public Object getMetadataValue(String key) {
        if (this.metadata == null) {
            return null;
        }
        return this.metadata.get(key);
    }

    @Nullable
    public Object getMetadataValue(String key, Object defaultValue) {
        if (this.metadata == null) {
            return defaultValue;
        }
        Object value = this.metadata.get(key);
        return value != null ? value : defaultValue;
    }

    public void removeMetadata(String key) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)key), (Object)"A non-empty key is required.");
        if (this.metadata == null) {
            return;
        }
        this.metadata.remove(key);
    }

    static {
        classSizes.put(Byte.TYPE, 1);
        classSizes.put(Byte.class, 1);
        classSizes.put(Character.TYPE, 2);
        classSizes.put(Character.class, 2);
        classSizes.put(Short.TYPE, 2);
        classSizes.put(Short.class, 2);
        classSizes.put(Boolean.TYPE, 4);
        classSizes.put(Boolean.class, 4);
        classSizes.put(Integer.TYPE, 4);
        classSizes.put(Integer.class, 4);
        classSizes.put(Float.TYPE, 4);
        classSizes.put(Float.class, 4);
        classSizes.put(Long.TYPE, 8);
        classSizes.put(Long.class, 8);
        classSizes.put(Double.TYPE, 8);
        classSizes.put(Double.class, 8);
        classSizes.put(DateTime.class, 8);
        classSizes.put(Date.class, 8);
        classSizes.put(ZonedDateTime.class, 8);
    }

    public static class ProcessingError {
        private final FailureCause cause;
        private final String message;
        private final String details;

        public ProcessingError(@Nonnull FailureCause cause, @Nonnull String message, @Nonnull String details) {
            this.cause = cause;
            this.message = message;
            this.details = details;
        }

        @Nonnull
        public FailureCause getCause() {
            return this.cause;
        }

        @Nonnull
        public String getMessage() {
            return this.message;
        }

        @Nonnull
        public String getDetails() {
            return this.details;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProcessingError that = (ProcessingError)o;
            return Objects.equal((Object)this.cause, (Object)that.cause) && Objects.equal((Object)this.message, (Object)that.message) && Objects.equal((Object)this.details, (Object)that.details);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.cause, this.message, this.details});
        }
    }

    @Deprecated
    public static class MessageIdFunction
    implements Function<Message, String> {
        public String apply(Message input) {
            return input.getId();
        }
    }

    private static class Counter
    extends Recording {
        private final String name;
        private final int counter;

        public Counter(String name, int counter) {
            this.name = name;
            this.counter = counter;
        }

        public String toString() {
            return this.name + ": " + this.counter;
        }
    }

    private static class Timing
    extends Recording {
        private final String name;
        private final long elapsedNanos;

        Timing(String name, long elapsedNanos) {
            this.name = name;
            this.elapsedNanos = elapsedNanos;
        }

        public String toString() {
            return this.name + ": " + TimeUnit.NANOSECONDS.toMicros(this.elapsedNanos) + "micros";
        }
    }

    public static abstract class Recording {
        static Timing timing(String name, long elapsedNanos) {
            return new Timing(name, elapsedNanos);
        }

        public static Counter counter(String name, int counter) {
            return new Counter(name, counter);
        }
    }
}

