/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.inject;

import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.google.common.util.concurrent.Service;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.apache.shiro.realm.AuthorizingRealm;
import org.graylog2.audit.AuditEventSender;
import org.graylog2.audit.AuditEventType;
import org.graylog2.audit.PluginAuditEventTypes;
import org.graylog2.audit.formatter.AuditEventFormatter;
import org.graylog2.contentpacks.constraints.ConstraintChecker;
import org.graylog2.contentpacks.facades.EntityFacade;
import org.graylog2.contentpacks.model.ModelType;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.decorators.SearchResponseDecorator;
import org.graylog2.plugin.indexer.retention.RetentionStrategy;
import org.graylog2.plugin.indexer.rotation.RotationStrategy;
import org.graylog2.plugin.inject.JacksonSubTypes;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.graylog2.plugin.inputs.transports.Transport;
import org.graylog2.plugin.lookup.LookupCache;
import org.graylog2.plugin.lookup.LookupCacheConfiguration;
import org.graylog2.plugin.lookup.LookupDataAdapter;
import org.graylog2.plugin.lookup.LookupDataAdapterConfiguration;
import org.graylog2.plugin.outputs.MessageOutput;
import org.graylog2.plugin.security.PasswordAlgorithm;
import org.graylog2.plugin.security.PluginPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Graylog2Module
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(Graylog2Module.class);
    public static final String SYSTEM_REST_RESOURCES = "systemRestResources";

    protected void installTransport(MapBinder<String, Transport.Factory<? extends Transport>> mapBinder, String name, Class<? extends Transport> transportClass) {
        Class<?> configClass = this.findInnerClassAnnotatedWith(ConfigClass.class, transportClass, Transport.Config.class);
        Class<?> factoryClass = this.findInnerClassAnnotatedWith(FactoryClass.class, transportClass, Transport.Factory.class);
        if (configClass == null) {
            LOG.error("Unable to find an inner class annotated with @ConfigClass in transport {}. This transport will not be available!", transportClass);
            return;
        }
        if (factoryClass == null) {
            LOG.error("Unable to find an inner class annotated with @FactoryClass in transport {}. This transport will not be available!", transportClass);
            return;
        }
        this.installTransport(mapBinder, name, transportClass, configClass, factoryClass);
    }

    protected void installTransport(MapBinder<String, Transport.Factory<? extends Transport>> mapBinder, String name, Class<? extends Transport> transportClass, Class<? extends Transport.Config> configClass, Class<? extends Transport.Factory<? extends Transport>> factoryClass) {
        Key factoryKey = Key.get(factoryClass);
        this.install(new FactoryModuleBuilder().implement(Transport.class, transportClass).implement(Transport.Config.class, configClass).build(factoryClass));
        mapBinder.addBinding((Object)name).to(factoryKey);
    }

    protected void installCodec(MapBinder<String, Codec.Factory<? extends Codec>> mapBinder, Class<? extends Codec> codecClass) {
        if (codecClass.isAnnotationPresent(org.graylog2.plugin.inputs.annotations.Codec.class)) {
            org.graylog2.plugin.inputs.annotations.Codec a = codecClass.getAnnotation(org.graylog2.plugin.inputs.annotations.Codec.class);
            this.installCodec(mapBinder, a.name(), codecClass);
        } else {
            LOG.error("Codec {} not annotated with {}. Cannot determine its id. This is a bug, please use that annotation, this codec will not be available", codecClass, org.graylog2.plugin.inputs.annotations.Codec.class);
        }
    }

    protected void installCodec(MapBinder<String, Codec.Factory<? extends Codec>> mapBinder, String name, Class<? extends Codec> codecClass) {
        Class<?> configClass = this.findInnerClassAnnotatedWith(ConfigClass.class, codecClass, Codec.Config.class);
        Class<?> factoryClass = this.findInnerClassAnnotatedWith(FactoryClass.class, codecClass, Codec.Factory.class);
        if (configClass == null) {
            LOG.error("Unable to find an inner class annotated with @ConfigClass in codec {}. This codec will not be available!", codecClass);
            return;
        }
        if (factoryClass == null) {
            LOG.error("Unable to find an inner class annotated with @FactoryClass in codec {}. This codec will not be available!", codecClass);
            return;
        }
        this.installCodec(mapBinder, name, codecClass, configClass, factoryClass);
    }

    protected void installCodec(MapBinder<String, Codec.Factory<? extends Codec>> mapBinder, String name, Class<? extends Codec> codecClass, Class<? extends Codec.Config> configClass, Class<? extends Codec.Factory<? extends Codec>> factoryClass) {
        Key factoryKey = Key.get(factoryClass);
        this.install(new FactoryModuleBuilder().implement(Codec.class, codecClass).implement(Codec.Config.class, configClass).build(factoryClass));
        mapBinder.addBinding((Object)name).to(factoryKey);
    }

    @Nullable
    protected Class<?> findInnerClassAnnotatedWith(Class<? extends Annotation> annotationClass, Class<?> containingClass, Class<?> targetClass) {
        Class<?>[] declaredClasses = containingClass.getDeclaredClasses();
        Class<?> annotatedClass = null;
        for (Class<?> declaredClass : declaredClasses) {
            if (!declaredClass.isAnnotationPresent(annotationClass)) continue;
            if (targetClass.isAssignableFrom(declaredClass)) {
                if (annotatedClass != null) {
                    LOG.error("Multiple annotations for {} found in {}. This is invalid.", (Object)annotatedClass.getSimpleName(), containingClass);
                    return null;
                }
                annotatedClass = declaredClass;
                continue;
            }
            LOG.error("{} annotated as {} is not extending the expected {}. Did you forget to implement the correct interface?", new Object[]{declaredClass, annotationClass.getSimpleName(), targetClass});
            return null;
        }
        return annotatedClass;
    }

    protected MapBinder<String, Codec.Factory<? extends Codec>> codecMapBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)new TypeLiteral<Codec.Factory<? extends Codec>>(){});
    }

    protected MapBinder<String, Transport.Factory<? extends Transport>> transportMapBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)new TypeLiteral<Transport.Factory<? extends Transport>>(){});
    }

    protected MapBinder<String, MessageInput.Factory<? extends MessageInput>> inputsMapBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)new TypeLiteral<MessageInput.Factory<? extends MessageInput>>(){});
    }

    protected MapBinder<String, RotationStrategy> rotationStrategiesMapBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), String.class, RotationStrategy.class);
    }

    protected MapBinder<String, RetentionStrategy> retentionStrategyMapBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), String.class, RetentionStrategy.class);
    }

    protected void installRotationStrategy(MapBinder<String, RotationStrategy> mapBinder, Class<? extends RotationStrategy> target) {
        mapBinder.addBinding((Object)target.getCanonicalName()).to(target);
    }

    protected void installRetentionStrategy(MapBinder<String, RetentionStrategy> mapBinder, Class<? extends RetentionStrategy> target) {
        mapBinder.addBinding((Object)target.getCanonicalName()).to(target);
    }

    protected <T extends MessageInput> void installInput(MapBinder<String, MessageInput.Factory<? extends MessageInput>> inputMapBinder, Class<T> target, Class<? extends MessageInput.Factory<T>> targetFactory) {
        this.install(new FactoryModuleBuilder().implement(MessageInput.class, target).build(targetFactory));
        inputMapBinder.addBinding((Object)target.getCanonicalName()).to(Key.get(targetFactory));
    }

    protected <T extends MessageInput> void installInput(MapBinder<String, MessageInput.Factory<? extends MessageInput>> inputMapBinder, Class<T> target) {
        Class<?> factoryClass = this.findInnerClassAnnotatedWith(FactoryClass.class, target, MessageInput.Factory.class);
        if (factoryClass == null) {
            LOG.error("Unable to find an inner class annotated with @FactoryClass in input {}. This input will not be available!", target);
            return;
        }
        this.installInput(inputMapBinder, target, factoryClass);
    }

    protected MapBinder<String, MessageOutput.Factory<? extends MessageOutput>> outputsMapBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)new TypeLiteral<MessageOutput.Factory<? extends MessageOutput>>(){});
    }

    protected <T extends MessageOutput> void installOutput(MapBinder<String, MessageOutput.Factory<? extends MessageOutput>> outputMapBinder, Class<T> target, Class<? extends MessageOutput.Factory<T>> targetFactory) {
        this.install(new FactoryModuleBuilder().implement(MessageOutput.class, target).build(targetFactory));
        outputMapBinder.addBinding((Object)target.getCanonicalName()).to(Key.get(targetFactory));
    }

    protected MapBinder<String, MessageOutput.Factory2<? extends MessageOutput>> outputsMapBinder2() {
        return MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)new TypeLiteral<MessageOutput.Factory2<? extends MessageOutput>>(){});
    }

    protected <T extends MessageOutput> void installOutput2(MapBinder<String, MessageOutput.Factory2<? extends MessageOutput>> outputMapBinder, Class<T> target, Class<? extends MessageOutput.Factory2<T>> targetFactory) {
        this.install(new FactoryModuleBuilder().implement(MessageOutput.class, target).build(targetFactory));
        outputMapBinder.addBinding((Object)target.getCanonicalName()).to(Key.get(targetFactory));
    }

    protected <T extends MessageOutput> void installOutput(MapBinder<String, MessageOutput.Factory<? extends MessageOutput>> outputMapBinder, Class<T> target) {
        Class<?> factoryClass = this.findInnerClassAnnotatedWith(FactoryClass.class, target, MessageOutput.Factory.class);
        if (factoryClass == null) {
            LOG.error("Unable to find an inner class annotated with @FactoryClass in output {}. This output will not be available!", target);
            return;
        }
        this.installOutput(outputMapBinder, target, factoryClass);
    }

    protected Multibinder<PluginPermissions> permissionsBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), PluginPermissions.class);
    }

    protected void installPermissions(Multibinder<PluginPermissions> classMultibinder, Class<? extends PluginPermissions> permissionsClass) {
        classMultibinder.addBinding().to(permissionsClass);
    }

    protected Multibinder<PluginAuditEventTypes> auditEventTypesBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), PluginAuditEventTypes.class);
    }

    protected void installAuditEventTypes(Multibinder<PluginAuditEventTypes> classMultibinder, Class<? extends PluginAuditEventTypes> auditEventTypesClass) {
        classMultibinder.addBinding().to(auditEventTypesClass);
    }

    protected MapBinder<AuditEventType, AuditEventFormatter> auditEventFormatterMapBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), AuditEventType.class, AuditEventFormatter.class);
    }

    protected void installAuditEventFormatter(MapBinder<AuditEventType, AuditEventFormatter> auditEventFormatterMapBinder, AuditEventType auditEventType, Class<? extends AuditEventFormatter> auditEventFormatter) {
        auditEventFormatterMapBinder.addBinding((Object)auditEventType).to(auditEventFormatter);
    }

    protected OptionalBinder<AuditEventSender> auditEventSenderBinder() {
        return OptionalBinder.newOptionalBinder((Binder)this.binder(), AuditEventSender.class);
    }

    @Nonnull
    protected Multibinder<Class<? extends DynamicFeature>> jerseyDynamicFeatureBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new DynamicFeatureType());
    }

    @Nonnull
    protected Multibinder<Class<? extends ContainerResponseFilter>> jerseyContainerResponseFilterBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new ContainerResponseFilterType());
    }

    @Nonnull
    protected Multibinder<Class<? extends ExceptionMapper>> jerseyExceptionMapperBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new ExceptionMapperType());
    }

    @Nonnull
    protected Multibinder<Class> jerseyAdditionalComponentsBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), Class.class, (Annotation)Names.named((String)"additionalJerseyComponents"));
    }

    protected Multibinder<Service> serviceBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), Service.class);
    }

    protected MapBinder<String, PasswordAlgorithm> passwordAlgorithmBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), String.class, PasswordAlgorithm.class);
    }

    protected MapBinder<String, AuthenticatingRealm> authenticationRealmBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), String.class, AuthenticatingRealm.class);
    }

    protected MapBinder<String, AuthorizingRealm> authorizationOnlyRealmBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), String.class, AuthorizingRealm.class);
    }

    protected MapBinder<String, SearchResponseDecorator.Factory> searchResponseDecoratorBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), String.class, SearchResponseDecorator.Factory.class);
    }

    protected void installSearchResponseDecorator(MapBinder<String, SearchResponseDecorator.Factory> searchResponseDecoratorBinder, Class<? extends SearchResponseDecorator> searchResponseDecoratorClass, Class<? extends SearchResponseDecorator.Factory> searchResponseDecoratorFactoryClass) {
        this.install(new FactoryModuleBuilder().implement(SearchResponseDecorator.class, searchResponseDecoratorClass).build(searchResponseDecoratorFactoryClass));
        searchResponseDecoratorBinder.addBinding((Object)searchResponseDecoratorClass.getCanonicalName()).to(searchResponseDecoratorFactoryClass);
    }

    protected MapBinder<String, AlertCondition.Factory> alertConditionBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), String.class, AlertCondition.Factory.class);
    }

    protected void installAlertCondition(MapBinder<String, AlertCondition.Factory> alertConditionBinder, Class<? extends AlertCondition> alertConditionClass, Class<? extends AlertCondition.Factory> alertConditionFactoryClass) {
        this.install(new FactoryModuleBuilder().implement(AlertCondition.class, alertConditionClass).build(alertConditionFactoryClass));
        alertConditionBinder.addBinding((Object)alertConditionClass.getCanonicalName()).to(alertConditionFactoryClass);
    }

    protected void installAlertConditionWithCustomName(MapBinder<String, AlertCondition.Factory> alertConditionBinder, String identifier, Class<? extends AlertCondition> alertConditionClass, Class<? extends AlertCondition.Factory> alertConditionFactoryClass) {
        this.install(new FactoryModuleBuilder().implement(AlertCondition.class, alertConditionClass).build(alertConditionFactoryClass));
        alertConditionBinder.addBinding((Object)identifier).to(alertConditionFactoryClass);
    }

    protected MapBinder<String, LookupCache.Factory> lookupCacheBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), String.class, LookupCache.Factory.class);
    }

    protected void installLookupCache(String name, Class<? extends LookupCache> cacheClass, Class<? extends LookupCache.Factory> factoryClass, Class<? extends LookupCacheConfiguration> configClass) {
        this.install(new FactoryModuleBuilder().implement(LookupCache.class, cacheClass).build(factoryClass));
        this.lookupCacheBinder().addBinding((Object)name).to(factoryClass);
        this.registerJacksonSubtype(configClass, name);
    }

    protected MapBinder<String, LookupDataAdapter.Factory> lookupDataAdapterBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), String.class, LookupDataAdapter.Factory.class);
    }

    protected MapBinder<String, LookupDataAdapter.Factory2> lookupDataAdapterBinder2() {
        return MapBinder.newMapBinder((Binder)this.binder(), String.class, LookupDataAdapter.Factory2.class);
    }

    protected void installLookupDataAdapter(String name, Class<? extends LookupDataAdapter> adapterClass, Class<? extends LookupDataAdapter.Factory> factoryClass, Class<? extends LookupDataAdapterConfiguration> configClass) {
        this.install(new FactoryModuleBuilder().implement(LookupDataAdapter.class, adapterClass).build(factoryClass));
        this.lookupDataAdapterBinder().addBinding((Object)name).to(factoryClass);
        this.registerJacksonSubtype(configClass, name);
    }

    protected void installLookupDataAdapter2(String name, Class<? extends LookupDataAdapter> adapterClass, Class<? extends LookupDataAdapter.Factory2> factoryClass, Class<? extends LookupDataAdapterConfiguration> configClass) {
        this.install(new FactoryModuleBuilder().implement(LookupDataAdapter.class, adapterClass).build(factoryClass));
        this.lookupDataAdapterBinder2().addBinding((Object)name).to(factoryClass);
        this.registerJacksonSubtype(configClass, name);
    }

    protected Multibinder<NamedType> jacksonSubTypesBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), NamedType.class, JacksonSubTypes.class);
    }

    protected void registerJacksonSubtype(Class<?> klass) {
        this.registerJacksonSubtype(klass, null);
    }

    protected void registerJacksonSubtype(Class<?> klass, String name) {
        this.jacksonSubTypesBinder().addBinding().toInstance((Object)new NamedType(klass, name));
    }

    protected Multibinder<Migration> migrationsBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), Migration.class);
    }

    protected MapBinder<ModelType, EntityFacade<?>> entityFacadeBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<ModelType>(){}, (TypeLiteral)new TypeLiteral<EntityFacade<?>>(){});
    }

    protected Multibinder<ConstraintChecker> constraintCheckerBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), ConstraintChecker.class);
    }

    protected void addSystemRestResource(Class<?> restResourceClass) {
        this.systemRestResourceBinder().addBinding().toInstance(restResourceClass);
    }

    private Multibinder<Class<?>> systemRestResourceBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<Class<?>>(){}, (Annotation)Names.named((String)SYSTEM_REST_RESOURCES));
    }

    private static class ExceptionMapperType
    extends TypeLiteral<Class<? extends ExceptionMapper>> {
        private ExceptionMapperType() {
        }
    }

    private static class ContainerResponseFilterType
    extends TypeLiteral<Class<? extends ContainerResponseFilter>> {
        private ContainerResponseFilterType() {
        }
    }

    private static class DynamicFeatureType
    extends TypeLiteral<Class<? extends DynamicFeature>> {
        private DynamicFeatureType() {
        }
    }
}

