/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.streams;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.bson.types.ObjectId;
import org.graylog.security.UserContext;
import org.graylog2.alarmcallbacks.AlarmCallbackConfiguration;
import org.graylog2.alarmcallbacks.AlarmCallbackConfigurationService;
import org.graylog2.alerts.AlertService;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.database.NotFoundException;
import org.graylog2.database.PaginatedList;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.configuration.ConfigurationException;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.streams.Output;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.plugin.streams.StreamRule;
import org.graylog2.rest.models.alarmcallbacks.requests.AlertReceivers;
import org.graylog2.rest.models.alarmcallbacks.requests.CreateAlarmCallbackRequest;
import org.graylog2.rest.models.streams.alerts.AlertConditionSummary;
import org.graylog2.rest.models.streams.alerts.requests.CreateConditionRequest;
import org.graylog2.rest.models.streams.requests.UpdateStreamRequest;
import org.graylog2.rest.models.system.outputs.responses.OutputSummary;
import org.graylog2.rest.resources.streams.requests.CloneStreamRequest;
import org.graylog2.rest.resources.streams.requests.CreateStreamRequest;
import org.graylog2.rest.resources.streams.responses.StreamListResponse;
import org.graylog2.rest.resources.streams.responses.StreamPageListResponse;
import org.graylog2.rest.resources.streams.responses.StreamResponse;
import org.graylog2.rest.resources.streams.responses.TestMatchResponse;
import org.graylog2.rest.resources.streams.rules.requests.CreateStreamRuleRequest;
import org.graylog2.search.SearchQuery;
import org.graylog2.search.SearchQueryField;
import org.graylog2.search.SearchQueryParser;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.streams.PaginatedStreamService;
import org.graylog2.streams.StreamDTO;
import org.graylog2.streams.StreamRouterEngine;
import org.graylog2.streams.StreamRuleService;
import org.graylog2.streams.StreamService;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="Streams", description="Manage streams")
@Path(value="/streams")
public class StreamResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(StreamResource.class);
    protected static final ImmutableMap<String, SearchQueryField> SEARCH_FIELD_MAPPING = ImmutableMap.builder().put((Object)"id", (Object)SearchQueryField.create("_id", SearchQueryField.Type.OBJECT_ID)).put((Object)"title", (Object)SearchQueryField.create("title")).put((Object)"description", (Object)SearchQueryField.create("description")).build();
    private final PaginatedStreamService paginatedStreamService;
    private final StreamService streamService;
    private final StreamRuleService streamRuleService;
    private final StreamRouterEngine.Factory streamRouterEngineFactory;
    private final IndexSetRegistry indexSetRegistry;
    private final AlarmCallbackConfigurationService alarmCallbackConfigurationService;
    private final AlertService alertService;
    private final SearchQueryParser searchQueryParser;

    @Inject
    public StreamResource(StreamService streamService, PaginatedStreamService paginatedStreamService, StreamRuleService streamRuleService, StreamRouterEngine.Factory streamRouterEngineFactory, IndexSetRegistry indexSetRegistry, AlarmCallbackConfigurationService alarmCallbackConfigurationService, AlertService alertService) {
        this.streamService = streamService;
        this.streamRuleService = streamRuleService;
        this.streamRouterEngineFactory = streamRouterEngineFactory;
        this.indexSetRegistry = indexSetRegistry;
        this.alarmCallbackConfigurationService = alarmCallbackConfigurationService;
        this.alertService = alertService;
        this.paginatedStreamService = paginatedStreamService;
        this.searchQueryParser = new SearchQueryParser("title", (Map<String, SearchQueryField>)SEARCH_FIELD_MAPPING);
    }

    @POST
    @Timed
    @ApiOperation(value="Create a stream")
    @RequiresPermissions(value={"streams:create"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @AuditEvent(type="server:stream:create")
    public Response create(@ApiParam(name="JSON body", required=true) CreateStreamRequest cr, @Context UserContext userContext) throws ValidationException {
        Stream stream = this.streamService.create(cr, this.getCurrentUser().getName());
        stream.setDisabled(true);
        IndexSet indexSet = stream.getIndexSet();
        if (!indexSet.getConfig().isWritable()) {
            throw new BadRequestException("Assigned index set must be writable!");
        }
        if (!indexSet.getConfig().isRegularIndex()) {
            throw new BadRequestException("Assigned index set is not usable");
        }
        Set<StreamRule> streamRules = cr.rules().stream().map(streamRule -> this.streamRuleService.create(null, (CreateStreamRuleRequest)streamRule)).collect(Collectors.toSet());
        String id = this.streamService.saveWithRulesAndOwnership(stream, streamRules, userContext.getUser());
        ImmutableMap result = ImmutableMap.of((Object)"stream_id", (Object)id);
        URI streamUri = this.getUriBuilderToSelf().path(StreamResource.class).path("{streamId}").build(new Object[]{id});
        return Response.created((URI)streamUri).entity((Object)result).build();
    }

    @GET
    @Timed
    @Path(value="/paginated")
    @ApiOperation(value="Get a paginated list of streams")
    @Produces(value={"application/json"})
    public StreamPageListResponse getPage(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="query") @QueryParam(value="query") @DefaultValue(value="") String query, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="title,description") @DefaultValue(value="title") @QueryParam(value="sort") String sort, @ApiParam(name="order", value="The sort direction", allowableValues="asc, desc") @DefaultValue(value="asc") @QueryParam(value="order") String order) {
        SearchQuery searchQuery;
        try {
            searchQuery = this.searchQueryParser.parse(query);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Invalid argument in search query: " + e.getMessage());
        }
        Predicate<StreamDTO> permissionFilter = streamDTO -> this.isPermitted("streams:read", streamDTO.id());
        PaginatedList<StreamDTO> result = this.paginatedStreamService.findPaginated(searchQuery, permissionFilter, page, perPage, sort, order);
        List<String> streamIds = result.stream().map(streamDTO -> streamDTO.id()).collect(Collectors.toList());
        Map<String, List<StreamRule>> streamRuleMap = this.streamRuleService.loadForStreamIds(streamIds);
        List<StreamDTO> streams = result.stream().map(streamDTO -> {
            List<StreamRule> rules = streamRuleMap.getOrDefault(streamDTO.id(), Collections.emptyList());
            return streamDTO.toBuilder().rules(rules).build();
        }).collect(Collectors.toList());
        long total = this.paginatedStreamService.count();
        PaginatedList streamDTOS = new PaginatedList(streams, result.pagination().total(), result.pagination().page(), result.pagination().perPage());
        return StreamPageListResponse.create(query, streamDTOS.pagination(), total, sort, order, streams);
    }

    @GET
    @Timed
    @ApiOperation(value="Get a list of all streams")
    @Deprecated
    @Produces(value={"application/json"})
    public StreamListResponse get() {
        List<Stream> allStreams = this.streamService.loadAll();
        ArrayList<Stream> streams = new ArrayList<Stream>(allStreams.size());
        for (Stream stream : allStreams) {
            if (!this.isPermitted("streams:read", stream.getId())) continue;
            streams.add(stream);
        }
        return StreamListResponse.create(streams.size(), streams.stream().map(this::streamToResponse).collect(Collectors.toSet()));
    }

    @GET
    @Path(value="/enabled")
    @Timed
    @ApiOperation(value="Get a list of all enabled streams")
    @Produces(value={"application/json"})
    public StreamListResponse getEnabled() throws NotFoundException {
        List<Stream> enabledStreams = this.streamService.loadAllEnabled();
        ArrayList<Stream> streams = new ArrayList<Stream>(enabledStreams.size());
        for (Stream stream : enabledStreams) {
            if (!this.isPermitted("streams:read", stream.getId())) continue;
            streams.add(stream);
        }
        return StreamListResponse.create(streams.size(), streams.stream().map(this::streamToResponse).collect(Collectors.toSet()));
    }

    @GET
    @Path(value="/{streamId}")
    @Timed
    @ApiOperation(value="Get a single stream")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    public StreamResponse get(@ApiParam(name="streamId", required=true) @PathParam(value="streamId") @NotEmpty String streamId) throws NotFoundException {
        this.checkPermission("streams:read", streamId);
        return this.streamToResponse(this.streamService.load(streamId));
    }

    @PUT
    @Timed
    @Path(value="/{streamId}")
    @ApiOperation(value="Update a stream")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    @AuditEvent(type="server:stream:update")
    public StreamResponse update(@ApiParam(name="streamId", required=true) @PathParam(value="streamId") String streamId, @ApiParam(name="JSON body", required=true) @Valid @NotNull UpdateStreamRequest cr) throws NotFoundException, ValidationException {
        Optional<IndexSet> indexSet;
        Boolean removeMatchesFromDefaultStream;
        this.checkPermission("streams:edit", streamId);
        this.checkNotEditableStream(streamId, "The stream cannot be edited.");
        Stream stream = this.streamService.load(streamId);
        if (!Strings.isNullOrEmpty((String)cr.title())) {
            stream.setTitle(cr.title());
        }
        if (!Strings.isNullOrEmpty((String)cr.description())) {
            stream.setDescription(cr.description());
        }
        if (cr.matchingType() != null) {
            try {
                stream.setMatchingType(Stream.MatchingType.valueOf(cr.matchingType()));
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("Invalid matching type '" + cr.matchingType() + "' specified. Should be one of: " + Arrays.toString((Object[])Stream.MatchingType.values()));
            }
        }
        if ((removeMatchesFromDefaultStream = cr.removeMatchesFromDefaultStream()) != null) {
            stream.setRemoveMatchesFromDefaultStream(removeMatchesFromDefaultStream);
        }
        if (!Strings.isNullOrEmpty((String)cr.indexSetId())) {
            stream.setIndexSetId(cr.indexSetId());
        }
        if (!(indexSet = this.indexSetRegistry.get(stream.getIndexSetId())).isPresent()) {
            throw new BadRequestException("Index set with ID <" + stream.getIndexSetId() + "> does not exist!");
        }
        if (!indexSet.get().getConfig().isWritable()) {
            throw new BadRequestException("Assigned index set must be writable!");
        }
        if (!indexSet.get().getConfig().isRegularIndex()) {
            throw new BadRequestException("Assigned index set is not usable");
        }
        this.streamService.save(stream);
        return this.streamToResponse(stream);
    }

    @DELETE
    @Path(value="/{streamId}")
    @Timed
    @ApiOperation(value="Delete a stream")
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    @AuditEvent(type="server:stream:delete")
    public void delete(@ApiParam(name="streamId", required=true) @PathParam(value="streamId") String streamId) throws NotFoundException {
        this.checkPermission("streams:edit", streamId);
        this.checkNotEditableStream(streamId, "The stream cannot be deleted.");
        Stream stream = this.streamService.load(streamId);
        this.streamService.destroy(stream);
    }

    @POST
    @Path(value="/{streamId}/pause")
    @Timed
    @ApiOperation(value="Pause a stream")
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid or missing Stream id.")})
    @AuditEvent(type="server:stream:stop")
    public void pause(@ApiParam(name="streamId", required=true) @PathParam(value="streamId") @NotEmpty String streamId) throws NotFoundException, ValidationException {
        this.checkAnyPermission(new String[]{"streams:changestate", "streams:edit"}, streamId);
        this.checkNotEditableStream(streamId, "The stream cannot be paused.");
        Stream stream = this.streamService.load(streamId);
        this.streamService.pause(stream);
    }

    @POST
    @Path(value="/{streamId}/resume")
    @Timed
    @ApiOperation(value="Resume a stream")
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid or missing Stream id.")})
    @AuditEvent(type="server:stream:start")
    public void resume(@ApiParam(name="streamId", required=true) @PathParam(value="streamId") @NotEmpty String streamId) throws NotFoundException, ValidationException {
        this.checkAnyPermission(new String[]{"streams:changestate", "streams:edit"}, streamId);
        this.checkNotEditableStream(streamId, "The stream cannot be resumed.");
        Stream stream = this.streamService.load(streamId);
        this.streamService.resume(stream);
    }

    @POST
    @Path(value="/{streamId}/testMatch")
    @Timed
    @ApiOperation(value="Test matching of a stream against a supplied message")
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid or missing Stream id.")})
    @NoAuditEvent(value="only used for testing stream matches")
    public TestMatchResponse testMatch(@ApiParam(name="streamId", required=true) @PathParam(value="streamId") String streamId, @ApiParam(name="JSON body", required=true) @NotNull Map<String, Map<String, Object>> serialisedMessage) throws NotFoundException {
        this.checkPermission("streams:read", streamId);
        Stream stream = this.streamService.load(streamId);
        HashMap<String, Object> m = new HashMap<String, Object>(serialisedMessage.get("message"));
        String timeStamp = (String)MoreObjects.firstNonNull((Object)((String)m.get("timestamp")), (Object)DateTime.now((DateTimeZone)DateTimeZone.UTC).toString(ISODateTimeFormat.dateTime()));
        m.put("timestamp", Tools.dateTimeFromString(timeStamp));
        Message message = new Message(m);
        ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("stream-" + streamId + "-test-match-%d").build());
        StreamRouterEngine streamRouterEngine = this.streamRouterEngineFactory.create(Lists.newArrayList((Object[])new Stream[]{stream}), executor);
        List<StreamRouterEngine.StreamTestMatch> streamTestMatches = streamRouterEngine.testMatch(message);
        StreamRouterEngine.StreamTestMatch streamTestMatch = streamTestMatches.get(0);
        HashMap rules = Maps.newHashMap();
        for (Map.Entry<StreamRule, Boolean> match : streamTestMatch.getMatches().entrySet()) {
            rules.put(match.getKey().getId(), match.getValue());
        }
        return TestMatchResponse.create(streamTestMatch.isMatched(), rules);
    }

    @POST
    @Path(value="/{streamId}/clone")
    @Timed
    @ApiOperation(value="Clone a stream")
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid or missing Stream id.")})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @AuditEvent(type="server:stream:create")
    public Response cloneStream(@ApiParam(name="streamId", required=true) @PathParam(value="streamId") String streamId, @ApiParam(name="JSON body", required=true) @Valid @NotNull CloneStreamRequest cr, @Context UserContext userContext) throws ValidationException, NotFoundException {
        this.checkPermission("streams:create");
        this.checkPermission("streams:read", streamId);
        this.checkNotEditableStream(streamId, "The stream cannot be cloned.");
        Stream sourceStream = this.streamService.load(streamId);
        String creatorUser = this.getCurrentUser().getName();
        List<StreamRule> sourceStreamRules = this.streamRuleService.loadForStream(sourceStream);
        ImmutableSet.Builder newStreamRules = ImmutableSet.builderWithExpectedSize((int)sourceStreamRules.size());
        for (StreamRule streamRule : sourceStreamRules) {
            HashMap streamRuleData = Maps.newHashMapWithExpectedSize((int)6);
            streamRuleData.put("type", streamRule.getType().toInteger());
            streamRuleData.put("field", streamRule.getField());
            streamRuleData.put("value", streamRule.getValue());
            streamRuleData.put("inverted", streamRule.getInverted());
            streamRuleData.put("description", streamRule.getDescription());
            StreamRule newStreamRule = this.streamRuleService.create(streamRuleData);
            newStreamRules.add((Object)newStreamRule);
        }
        HashMap streamData = Maps.newHashMap();
        streamData.put("title", cr.title());
        streamData.put("description", cr.description());
        streamData.put("creator_user_id", creatorUser);
        streamData.put("created_at", Tools.nowUTC());
        streamData.put("matching_type", sourceStream.getMatchingType().toString());
        streamData.put("remove_matches_from_default_stream", cr.removeMatchesFromDefaultStream());
        streamData.put("disabled", true);
        streamData.put("index_set_id", cr.indexSetId());
        Stream stream = this.streamService.create(streamData);
        String savedStreamId = this.streamService.saveWithRulesAndOwnership(stream, (Collection<StreamRule>)newStreamRules.build(), userContext.getUser());
        ObjectId savedStreamObjectId = new ObjectId(savedStreamId);
        for (AlertCondition alertCondition : this.streamService.getAlertConditions(sourceStream)) {
            try {
                AlertCondition clonedAlertCondition = this.alertService.fromRequest(CreateConditionRequest.create(alertCondition.getType(), alertCondition.getTitle(), alertCondition.getParameters()), stream, creatorUser);
                this.streamService.addAlertCondition(stream, clonedAlertCondition);
            }
            catch (ConfigurationException e) {
                LOG.warn("Unable to clone alert condition <" + alertCondition + "> - skipping: ", (Throwable)e);
            }
        }
        for (AlarmCallbackConfiguration alarmCallbackConfiguration : this.alarmCallbackConfigurationService.getForStream(sourceStream)) {
            CreateAlarmCallbackRequest request = CreateAlarmCallbackRequest.create(alarmCallbackConfiguration);
            AlarmCallbackConfiguration alarmCallback = this.alarmCallbackConfigurationService.create(stream.getId(), request, this.getCurrentUser().getName());
            this.alarmCallbackConfigurationService.save(alarmCallback);
        }
        Set<ObjectId> outputIds = sourceStream.getOutputs().stream().map(Output::getId).map(ObjectId::new).collect(Collectors.toSet());
        this.streamService.addOutputs(savedStreamObjectId, outputIds);
        ImmutableMap result = ImmutableMap.of((Object)"stream_id", (Object)savedStreamId);
        URI streamUri = this.getUriBuilderToSelf().path(StreamResource.class).path("{streamId}").build(new Object[]{savedStreamId});
        return Response.created((URI)streamUri).entity((Object)result).build();
    }

    private StreamResponse streamToResponse(Stream stream) {
        List<String> emailAlertReceivers = stream.getAlertReceivers().get("emails");
        List<String> usersAlertReceivers = stream.getAlertReceivers().get("users");
        Collection alertConditions = this.streamService.getAlertConditions(stream).stream().map(alertCondition -> AlertConditionSummary.createWithoutGrace(alertCondition.getId(), alertCondition.getType(), alertCondition.getCreatorUserId(), alertCondition.getCreatedAt().toDate(), alertCondition.getParameters(), alertCondition.getTitle())).collect(Collectors.toList());
        return StreamResponse.create(stream.getId(), (String)stream.getFields().get("creator_user_id"), this.outputsToSummaries(stream.getOutputs()), stream.getMatchingType().name(), stream.getDescription(), stream.getFields().get("created_at").toString(), stream.getDisabled(), stream.getStreamRules(), alertConditions, AlertReceivers.create(emailAlertReceivers, usersAlertReceivers), stream.getTitle(), stream.getContentPack(), stream.isDefaultStream(), stream.getRemoveMatchesFromDefaultStream(), stream.getIndexSetId());
    }

    private Collection<OutputSummary> outputsToSummaries(Collection<Output> outputs) {
        return outputs.stream().map(output -> OutputSummary.create(output.getId(), output.getTitle(), output.getType(), output.getCreatorUserId(), new DateTime((Object)output.getCreatedAt()), output.getConfiguration(), output.getContentPack())).collect(Collectors.toSet());
    }

    private void checkNotEditableStream(String streamId, String message) {
        if ("000000000000000000000001".equals(streamId) || !Stream.streamIsEditable(streamId)) {
            throw new BadRequestException(message);
        }
    }
}

