/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.constraints.NotBlank;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.rest.resources.system.indexer.AutoValue_IndexTemplatesResource_IndexTemplateResponse;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="Indexer/Indices/Templates", description="Index Template Management")
@Path(value="/system/indexer/indices/templates")
@Produces(value={"application/json"})
public class IndexTemplatesResource
extends RestResource {
    private final Indices indices;
    private final IndexSetRegistry indexSetRegistry;

    @Inject
    public IndexTemplatesResource(Indices indices, IndexSetRegistry indexSetRegistry) {
        this.indices = indices;
        this.indexSetRegistry = indexSetRegistry;
    }

    @GET
    @Path(value="{indexSetId}")
    @Timed
    @ApiOperation(value="Get index template for the given index set")
    public IndexTemplateResponse get(@ApiParam(name="indexSetId") @PathParam(value="indexSetId") @NotBlank String indexSetId) {
        this.checkPermission("indexsets:read", indexSetId);
        IndexSet indexSet = this.indexSetRegistry.get(indexSetId).orElseThrow(() -> new NotFoundException("Index set " + indexSetId + " not found"));
        return this.createResponse(indexSet);
    }

    @GET
    @Timed
    @ApiOperation(value="Get index templates for all index sets")
    public Set<IndexTemplateResponse> getAll() {
        this.checkPermission("indexsets:read");
        return this.indexSetRegistry.getAll().stream().filter(indexSet -> this.isPermitted("indexsets:read", indexSet.getConfig().id())).map(this::createResponse).collect(Collectors.toSet());
    }

    @POST
    @Path(value="{indexSetId}/update")
    @Timed
    @ApiOperation(value="Updates the index template for the given index set in Elasticsearch")
    @AuditEvent(type="server:es_index_template:update")
    public IndexTemplateResponse sync(@ApiParam(name="indexSetId") @PathParam(value="indexSetId") @NotBlank String indexSetId) {
        this.checkPermission("indexsets:edit", indexSetId);
        IndexSet indexSet = this.indexSetRegistry.get(indexSetId).orElseThrow(() -> new NotFoundException("Index set " + indexSetId + " not found"));
        this.indices.ensureIndexTemplate(indexSet);
        return this.createResponse(indexSet);
    }

    @POST
    @Path(value="update")
    @Timed
    @ApiOperation(value="Updates the index templates for all index sets in Elasticsearch")
    @AuditEvent(type="server:es_index_template:update")
    public Set<IndexTemplateResponse> syncAll() {
        return this.indexSetRegistry.getAll().stream().filter(indexSet -> this.isPermitted("indexsets:edit", indexSet.getConfig().id())).map(indexSet -> {
            this.indices.ensureIndexTemplate((IndexSet)indexSet);
            return this.createResponse((IndexSet)indexSet);
        }).collect(Collectors.toSet());
    }

    private IndexTemplateResponse createResponse(IndexSet indexSet) {
        return IndexTemplateResponse.create(indexSet.getConfig().indexTemplateName(), this.indices.getIndexTemplate(indexSet));
    }

    @AutoValue
    public static abstract class IndexTemplateResponse {
        @JsonProperty(value="name")
        public abstract String name();

        @JsonProperty(value="template")
        public abstract Map<String, Object> template();

        public static IndexTemplateResponse create(String name, Map<String, Object> template) {
            return new AutoValue_IndexTemplatesResource_IndexTemplateResponse(name, template);
        }
    }
}

