/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.system.stats;

import com.google.inject.AbstractModule;
import org.graylog2.shared.system.stats.OshiService;
import org.graylog2.shared.system.stats.fs.FsProbe;
import org.graylog2.shared.system.stats.fs.JmxFsProbe;
import org.graylog2.shared.system.stats.fs.OshiFsProbe;
import org.graylog2.shared.system.stats.jvm.JvmProbe;
import org.graylog2.shared.system.stats.network.JmxNetworkProbe;
import org.graylog2.shared.system.stats.network.NetworkProbe;
import org.graylog2.shared.system.stats.network.OshiNetworkProbe;
import org.graylog2.shared.system.stats.os.JmxOsProbe;
import org.graylog2.shared.system.stats.os.OsProbe;
import org.graylog2.shared.system.stats.os.OshiOsProbe;
import org.graylog2.shared.system.stats.process.JmxProcessProbe;
import org.graylog2.shared.system.stats.process.OshiProcessProbe;
import org.graylog2.shared.system.stats.process.ProcessProbe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemStatsModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(SystemStatsModule.class);
    private final boolean disableNativeSystemStats;

    public SystemStatsModule(boolean disableNativeSystemStats) {
        this.disableNativeSystemStats = disableNativeSystemStats;
    }

    protected void configure() {
        boolean oshiLoaded = false;
        if (this.disableNativeSystemStats) {
            LOG.debug("OSHI disabled. Using JMX implementations.");
        } else {
            try {
                OshiService oshiService = new OshiService();
                this.bind(OshiService.class).toInstance((Object)oshiService);
                this.bind(FsProbe.class).to(OshiFsProbe.class).asEagerSingleton();
                this.bind(NetworkProbe.class).to(OshiNetworkProbe.class).asEagerSingleton();
                this.bind(OsProbe.class).to(OshiOsProbe.class).asEagerSingleton();
                this.bind(ProcessProbe.class).to(OshiProcessProbe.class).asEagerSingleton();
                oshiLoaded = true;
            }
            catch (Throwable e) {
                LOG.debug("Failed to load OSHI. Falling back to JMX implementations.", e);
            }
        }
        if (!oshiLoaded) {
            this.bind(FsProbe.class).to(JmxFsProbe.class).asEagerSingleton();
            this.bind(NetworkProbe.class).to(JmxNetworkProbe.class).asEagerSingleton();
            this.bind(OsProbe.class).to(JmxOsProbe.class).asEagerSingleton();
            this.bind(ProcessProbe.class).to(JmxProcessProbe.class).asEagerSingleton();
        }
        this.bind(JvmProbe.class).asEagerSingleton();
    }
}

