/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.system.stats.network;

import java.net.InterfaceAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.logging.log4j.util.Strings;
import org.graylog2.shared.system.stats.OshiService;
import org.graylog2.shared.system.stats.network.NetworkProbe;
import org.graylog2.shared.system.stats.network.NetworkStats;
import org.graylog2.utilities.IpSubnet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.NetworkIF;
import oshi.software.os.InternetProtocolStats;
import oshi.software.os.NetworkParams;

public class OshiNetworkProbe
implements NetworkProbe {
    private static final Logger LOG = LoggerFactory.getLogger(OshiNetworkProbe.class);
    private final OshiService service;

    @Inject
    public OshiNetworkProbe(OshiService service) {
        this.service = service;
    }

    @Override
    public NetworkStats networkStats() {
        String primaryInterface = "";
        NetworkParams networkParams = this.service.getOs().getNetworkParams();
        String defaultGateway = networkParams.getIpv4DefaultGateway();
        HashMap<String, NetworkStats.Interface> ifaces = new HashMap<String, NetworkStats.Interface>();
        for (NetworkIF it : this.service.getHal().getNetworkIFs()) {
            if (Strings.isNotBlank((String)defaultGateway)) {
                for (InterfaceAddress that : it.queryNetworkInterface().getInterfaceAddresses()) {
                    try {
                        IpSubnet ipSubnet = new IpSubnet(that.getAddress().getHostAddress() + "/" + that.getNetworkPrefixLength());
                        if (!ipSubnet.contains(defaultGateway)) continue;
                        primaryInterface = it.getName();
                    }
                    catch (UnknownHostException e) {
                        LOG.warn("Couldn't find primary interface", (Throwable)e);
                    }
                }
            }
            NetworkStats.Interface anInterface = NetworkStats.Interface.create(it.getName(), it.queryNetworkInterface().getInterfaceAddresses().stream().map(address -> address.getAddress().getHostAddress()).collect(Collectors.toSet()), it.getMacaddr(), it.getMTU(), NetworkStats.InterfaceStats.create(it.getPacketsRecv(), it.getInErrors(), it.getInDrops(), -1L, -1L, it.getPacketsSent(), it.getOutErrors(), -1L, -1L, -1L, it.getCollisions(), it.getBytesRecv(), it.getBytesSent()));
            ifaces.putIfAbsent(anInterface.name(), anInterface);
        }
        InternetProtocolStats stats = this.service.getOs().getInternetProtocolStats();
        InternetProtocolStats.TcpStats ipv4Stats = stats.getTCPv4Stats();
        InternetProtocolStats.TcpStats ipv6Stats = stats.getTCPv6Stats();
        NetworkStats.TcpStats tcpStats = NetworkStats.TcpStats.create(ipv4Stats.getConnectionsActive() + ipv6Stats.getConnectionsActive(), ipv4Stats.getConnectionsPassive() + ipv6Stats.getConnectionsPassive(), ipv4Stats.getConnectionFailures() + ipv6Stats.getConnectionFailures(), ipv4Stats.getConnectionsReset() + ipv6Stats.getConnectionsReset(), ipv4Stats.getConnectionsEstablished() + ipv6Stats.getConnectionsEstablished(), ipv4Stats.getSegmentsReceived() + ipv6Stats.getSegmentsReceived(), ipv4Stats.getSegmentsSent() + ipv6Stats.getSegmentsSent(), ipv4Stats.getSegmentsRetransmitted() + ipv6Stats.getSegmentsRetransmitted(), ipv4Stats.getInErrors() + ipv6Stats.getInErrors(), ipv4Stats.getOutResets() + ipv6Stats.getOutResets());
        return NetworkStats.create(primaryInterface, ifaces, tcpStats);
    }
}

