/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.system.stats.os;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.shared.system.stats.OshiService;
import org.graylog2.shared.system.stats.os.Memory;
import org.graylog2.shared.system.stats.os.OsProbe;
import org.graylog2.shared.system.stats.os.OsStats;
import org.graylog2.shared.system.stats.os.Processor;
import org.graylog2.shared.system.stats.os.Swap;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.VirtualMemory;

@Singleton
public class OshiOsProbe
implements OsProbe {
    private final OshiService service;

    @Inject
    public OshiOsProbe(OshiService service) {
        this.service = service;
    }

    @Override
    public OsStats osStats() {
        HardwareAbstractionLayer hardware = this.service.getHal();
        GlobalMemory globalMemory = hardware.getMemory();
        Memory mem = Memory.create(globalMemory.getTotal(), globalMemory.getAvailable(), (short)(globalMemory.getAvailable() * 100L / globalMemory.getTotal()), globalMemory.getTotal() - globalMemory.getAvailable(), (short)((globalMemory.getTotal() - globalMemory.getAvailable()) * 100L / globalMemory.getTotal()), globalMemory.getAvailable(), globalMemory.getTotal() - globalMemory.getAvailable());
        VirtualMemory virtualMemory = globalMemory.getVirtualMemory();
        Swap swap = Swap.create(virtualMemory.getSwapTotal(), virtualMemory.getSwapTotal() - virtualMemory.getSwapUsed(), virtualMemory.getSwapUsed());
        CentralProcessor centralProcessor = hardware.getProcessor();
        long[] prevTicks = centralProcessor.getSystemCpuLoadTicks();
        long[] ticks = centralProcessor.getSystemCpuLoadTicks();
        short user = (short)(ticks[CentralProcessor.TickType.USER.getIndex()] - prevTicks[CentralProcessor.TickType.USER.getIndex()]);
        short sys = (short)(ticks[CentralProcessor.TickType.SYSTEM.getIndex()] - prevTicks[CentralProcessor.TickType.SYSTEM.getIndex()]);
        short idle = (short)(ticks[CentralProcessor.TickType.IDLE.getIndex()] - prevTicks[CentralProcessor.TickType.IDLE.getIndex()]);
        short steal = (short)(ticks[CentralProcessor.TickType.STEAL.getIndex()] - prevTicks[CentralProcessor.TickType.STEAL.getIndex()]);
        CentralProcessor.ProcessorIdentifier processorIdentifier = centralProcessor.getProcessorIdentifier();
        Processor proc = Processor.create(processorIdentifier.getName(), processorIdentifier.getVendor(), (int)processorIdentifier.getVendorFreq() / 1000000, centralProcessor.getLogicalProcessorCount(), centralProcessor.getPhysicalPackageCount(), centralProcessor.getLogicalProcessorCount() / centralProcessor.getPhysicalPackageCount(), -1L, sys, user, idle, steal);
        return OsStats.create(centralProcessor.getSystemLoadAverage(3), this.service.getOs().getSystemUptime(), proc, mem, swap);
    }
}

