/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.scheduler;

import javax.inject.Inject;
import org.graylog.scheduler.JobSchedulerConfig;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.plugin.system.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJobSchedulerConfig
implements JobSchedulerConfig {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJobSchedulerConfig.class);
    private final NodeService nodeService;
    private final NodeId nodeId;

    @Inject
    public DefaultJobSchedulerConfig(NodeService nodeService, NodeId nodeId) {
        this.nodeService = nodeService;
        this.nodeId = nodeId;
    }

    @Override
    public boolean canStart() {
        try {
            return this.nodeService.byNodeId(this.nodeId).isMaster();
        }
        catch (NodeNotFoundException e) {
            LOG.error("Couldn't find current node <{}> in the database", (Object)this.nodeId.toString(), (Object)e);
            return false;
        }
    }

    @Override
    public boolean canExecute() {
        return true;
    }

    @Override
    public int numberOfWorkerThreads() {
        return 5;
    }
}

