/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indices;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.validation.constraints.NotEmpty;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.indexer.rotation.RotationStrategy;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.graylog2.rest.models.system.indices.RotationStrategies;
import org.graylog2.rest.models.system.indices.RotationStrategyDescription;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="System/Indices/Rotation", description="Index rotation strategy settings")
@Path(value="/system/indices/rotation")
@Produces(value={"application/json"})
@RequiresAuthentication
public class RotationStrategyResource
extends RestResource {
    private final Map<String, Provider<RotationStrategy>> rotationStrategies;
    private final ObjectMapper objectMapper;
    private final ClusterConfigService clusterConfigService;
    private final ElasticsearchConfiguration elasticsearchConfiguration;

    @Inject
    public RotationStrategyResource(Map<String, Provider<RotationStrategy>> rotationStrategies, ObjectMapper objectMapper, ClusterConfigService clusterConfigService, ElasticsearchConfiguration elasticsearchConfiguration) {
        this.rotationStrategies = Objects.requireNonNull(rotationStrategies);
        this.objectMapper = objectMapper;
        this.clusterConfigService = Objects.requireNonNull(clusterConfigService);
        this.elasticsearchConfiguration = elasticsearchConfiguration;
    }

    @GET
    @Path(value="strategies")
    @Timed
    @ApiOperation(value="List available rotation strategies", notes="This resource returns a list of all available rotation strategies on this Graylog node.")
    public RotationStrategies list() {
        Set<RotationStrategyDescription> strategies = this.rotationStrategies.keySet().stream().filter(this::isEnabledRotationStrategy).map(this::getRotationStrategyDescription).collect(Collectors.toSet());
        return RotationStrategies.create(strategies.size(), strategies);
    }

    @GET
    @Path(value="strategies/{strategy}")
    @Timed
    @ApiOperation(value="Show JSON schema for configuration of given rotation strategies", notes="This resource returns a JSON schema for the configuration of the given rotation strategy.")
    public RotationStrategyDescription configSchema(@ApiParam(name="strategy", value="The name of the rotation strategy", required=true) @PathParam(value="strategy") @NotEmpty String strategyName) {
        return this.getRotationStrategyDescription(strategyName);
    }

    private boolean isEnabledRotationStrategy(String strategyName) {
        Provider<RotationStrategy> provider = this.rotationStrategies.get(strategyName);
        if (provider == null) {
            throw new NotFoundException("Couldn't find rotation strategy for given type " + strategyName);
        }
        RotationStrategy rotationStrategy = (RotationStrategy)provider.get();
        return this.elasticsearchConfiguration.getEnabledRotationStrategies().contains(rotationStrategy.getStrategyName());
    }

    private RotationStrategyDescription getRotationStrategyDescription(String strategyName) {
        Provider<RotationStrategy> provider = this.rotationStrategies.get(strategyName);
        if (provider == null) {
            throw new NotFoundException("Couldn't find rotation strategy for given type " + strategyName);
        }
        RotationStrategy rotationStrategy = (RotationStrategy)provider.get();
        RotationStrategyConfig defaultConfig = rotationStrategy.defaultConfiguration();
        SchemaFactoryWrapper visitor = new SchemaFactoryWrapper();
        try {
            this.objectMapper.acceptJsonFormatVisitor(this.objectMapper.constructType(rotationStrategy.configurationClass()), (JsonFormatVisitorWrapper)visitor);
        }
        catch (JsonMappingException e) {
            throw new InternalServerErrorException("Couldn't generate JSON schema for rotation strategy " + strategyName, (Throwable)e);
        }
        return RotationStrategyDescription.create(strategyName, defaultConfig, visitor.finalSchema());
    }
}

