/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import com.google.common.collect.ImmutableMap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.views.search.views.ViewDTO;
import org.graylog.plugins.views.search.views.ViewService;
import org.graylog.security.UserContext;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.dashboards.events.DashboardDeletedEvent;
import org.graylog2.database.PaginatedList;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.database.users.User;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.rest.models.PaginatedResponse;
import org.graylog2.search.SearchQuery;
import org.graylog2.search.SearchQueryField;
import org.graylog2.search.SearchQueryParser;
import org.graylog2.shared.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Views")
@Path(value="/views")
@Produces(value={"application/json"})
@RequiresAuthentication
public class ViewsResource
extends RestResource
implements PluginRestResource {
    private static final Logger LOG = LoggerFactory.getLogger(ViewsResource.class);
    private static final ImmutableMap<String, SearchQueryField> SEARCH_FIELD_MAPPING = ImmutableMap.builder().put((Object)"id", (Object)SearchQueryField.create("id")).put((Object)"title", (Object)SearchQueryField.create("title")).put((Object)"summary", (Object)SearchQueryField.create("description")).build();
    private final ViewService dbService;
    private final SearchQueryParser searchQueryParser;
    private final ClusterEventBus clusterEventBus;

    @Inject
    public ViewsResource(ViewService dbService, ClusterEventBus clusterEventBus) {
        this.dbService = dbService;
        this.clusterEventBus = clusterEventBus;
        this.searchQueryParser = new SearchQueryParser("title", (Map<String, SearchQueryField>)SEARCH_FIELD_MAPPING);
    }

    @GET
    @ApiOperation(value="Get a list of all views")
    public PaginatedResponse<ViewDTO> views(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="id,title,created_at") @DefaultValue(value="title") @QueryParam(value="sort") String sortField, @ApiParam(name="order", value="The sort direction", allowableValues="asc, desc") @DefaultValue(value="asc") @QueryParam(value="order") String order, @ApiParam(name="query") @QueryParam(value="query") String query) {
        if (!ViewDTO.SORT_FIELDS.contains((Object)sortField.toLowerCase(Locale.ENGLISH))) {
            sortField = "title";
        }
        try {
            SearchQuery searchQuery = this.searchQueryParser.parse(query);
            PaginatedList<ViewDTO> result = this.dbService.searchPaginated(searchQuery, view -> this.isPermitted("view:read", view.id()) || view.type().equals((Object)ViewDTO.Type.DASHBOARD) && this.isPermitted("dashboards:read", view.id()), order, sortField, page, perPage);
            return PaginatedResponse.create("views", result, query);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }

    @GET
    @Path(value="{id}")
    @ApiOperation(value="Get a single view")
    public ViewDTO get(@ApiParam(name="id") @PathParam(value="id") @NotEmpty String id) {
        if ("default".equals(id)) {
            return this.dbService.getDefault().filter(dto -> this.isPermitted("view:read", dto.id())).orElseThrow(() -> new NotFoundException("Default view doesn't exist"));
        }
        ViewDTO view = this.loadView(id);
        if (this.isPermitted("view:read", id) || view.type().equals((Object)ViewDTO.Type.DASHBOARD) && this.isPermitted("dashboards:read", view.id())) {
            return view;
        }
        throw this.viewNotFoundException(id);
    }

    @POST
    @ApiOperation(value="Create a new view")
    @AuditEvent(type="views:view:create")
    public ViewDTO create(@ApiParam @Valid ViewDTO dto, @Context UserContext userContext) throws ValidationException {
        if (dto.type().equals((Object)ViewDTO.Type.DASHBOARD)) {
            this.checkPermission("dashboards:create");
        }
        User user = userContext.getUser();
        ViewDTO savedDto = this.dbService.saveWithOwner(dto.toBuilder().owner(user.getName()).build(), user);
        return savedDto;
    }

    @PUT
    @Path(value="{id}")
    @ApiOperation(value="Update view")
    @AuditEvent(type="views:view:update")
    public ViewDTO update(@ApiParam(name="id") @PathParam(value="id") @NotEmpty String id, @ApiParam @Valid ViewDTO dto) {
        if (dto.type().equals((Object)ViewDTO.Type.DASHBOARD)) {
            this.checkAnyPermission(new String[]{"view:edit", "dashboards:edit"}, id);
        } else {
            this.checkPermission("view:edit", id);
        }
        return this.dbService.update(dto.toBuilder().id(id).build());
    }

    @PUT
    @Path(value="{id}/default")
    @ApiOperation(value="Configures the view as default view")
    @AuditEvent(type="views:default_view:set")
    public void setDefault(@ApiParam(name="id") @PathParam(value="id") @NotEmpty String id) {
        this.checkPermission("view:read", id);
        this.checkPermission("default-view:set");
        this.dbService.saveDefault(this.loadView(id));
    }

    @DELETE
    @Path(value="{id}")
    @ApiOperation(value="Delete view")
    @AuditEvent(type="views:view:delete")
    public ViewDTO delete(@ApiParam(name="id") @PathParam(value="id") @NotEmpty String id) {
        this.checkPermission("view:delete", id);
        ViewDTO dto = this.loadView(id);
        this.dbService.delete(id);
        this.triggerDeletedEvent(dto);
        return dto;
    }

    private void triggerDeletedEvent(ViewDTO dto) {
        if (dto != null && dto.type() != null && dto.type().equals((Object)ViewDTO.Type.DASHBOARD)) {
            DashboardDeletedEvent dashboardDeletedEvent = DashboardDeletedEvent.create(dto.id());
            this.clusterEventBus.post(dashboardDeletedEvent);
        }
    }

    private ViewDTO loadView(String id) {
        try {
            return this.dbService.get(id).orElseThrow(() -> this.viewNotFoundException(id));
        }
        catch (IllegalArgumentException ignored) {
            throw this.viewNotFoundException(id);
        }
    }

    private NotFoundException viewNotFoundException(String id) {
        return new NotFoundException("View " + id + " doesn't exist");
    }
}

