/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security.realm;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAccount;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.permission.AllPermission;
import org.apache.shiro.authz.permission.PermissionResolver;
import org.apache.shiro.authz.permission.WildcardPermissionResolver;
import org.apache.shiro.realm.SimpleAccountRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootAccountRealm
extends SimpleAccountRealm {
    private static final Logger LOG = LoggerFactory.getLogger(RootAccountRealm.class);
    public static final String NAME = "root-user";

    @Inject
    RootAccountRealm(@Named(value="root_username") String rootUsername, @Named(value="root_password_sha2") String rootPasswordSha2) {
        this.setCachingEnabled(false);
        this.setCredentialsMatcher((CredentialsMatcher)new HashedCredentialsMatcher("SHA-256"));
        this.setName("root-account-realm");
        this.setPermissionResolver((PermissionResolver)new WildcardPermissionResolver(true));
        this.addRootAccount(rootUsername, rootPasswordSha2);
    }

    private void addRootAccount(String username, String password) {
        LOG.debug("Adding root account named {}, having all permissions", (Object)username);
        this.add(new SimpleAccount((Object)username, (Object)password, this.getName(), CollectionUtils.asSet((Object[])new String[]{"root"}), CollectionUtils.asSet((Object[])new Permission[]{new AllPermission()})));
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        AuthenticationInfo authenticationInfo = super.doGetAuthenticationInfo(token);
        if (authenticationInfo instanceof SimpleAccount) {
            SimpleAccount account = (SimpleAccount)authenticationInfo;
            account.setPrincipals((PrincipalCollection)new SimplePrincipalCollection((Object)"local:admin", NAME));
            return account;
        }
        return null;
    }
}

