/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.messages;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog2.plugin.Message;

public class SetField
extends AbstractFunction<Void> {
    public static final String NAME = "set_field";
    private final ParameterDescriptor<String, String> fieldParam = ParameterDescriptor.string("field").description("The new field name").build();
    private final ParameterDescriptor<Object, Object> valueParam = ParameterDescriptor.object("value").description("The new field value").build();
    private final ParameterDescriptor<String, String> prefixParam = ParameterDescriptor.string("prefix").optional().description("The prefix for the field name").build();
    private final ParameterDescriptor<String, String> suffixParam = ParameterDescriptor.string("suffix").optional().description("The suffix for the field name").build();
    private final ParameterDescriptor<Message, Message> messageParam = ParameterDescriptor.type("message", Message.class).optional().description("The message to use, defaults to '$message'").build();
    private final ParameterDescriptor<Object, Object> defaultParam = ParameterDescriptor.object("default").optional().description("Used when value not available").build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void evaluate(FunctionArgs args, EvaluationContext context) {
        String field = this.fieldParam.required(args, context);
        Object value = null;
        try {
            value = this.valueParam.required(args, context);
        }
        catch (Exception e) {
            if (!args.isPresent("default")) {
                throw e;
            }
        }
        finally {
            if (value == null) {
                value = this.defaultParam.optional(args, context).orElse(null);
            }
        }
        if (!Strings.isNullOrEmpty((String)field)) {
            Message message = this.messageParam.optional(args, context).orElse(context.currentMessage());
            Optional<String> prefix = this.prefixParam.optional(args, context);
            Optional<String> suffix = this.suffixParam.optional(args, context);
            if (prefix.isPresent()) {
                field = prefix.get() + field;
            }
            if (suffix.isPresent()) {
                field = field + suffix.get();
            }
            message.addField(field, value);
        }
        return null;
    }

    @Override
    public FunctionDescriptor<Void> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Void.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.fieldParam, this.valueParam, this.prefixParam, this.suffixParam, this.messageParam, this.defaultParam)).description("Sets a new field in a message").build();
    }
}

