/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.shares;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.EventBus;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.shiro.subject.Subject;
import org.graylog.grn.GRN;
import org.graylog.grn.GRNRegistry;
import org.graylog.security.BuiltinCapabilities;
import org.graylog.security.Capability;
import org.graylog.security.DBGrantService;
import org.graylog.security.GrantDTO;
import org.graylog.security.entities.EntityDependencyPermissionChecker;
import org.graylog.security.entities.EntityDependencyResolver;
import org.graylog.security.entities.EntityDescriptor;
import org.graylog.security.events.EntitySharesUpdateEvent;
import org.graylog.security.shares.EntityShareRequest;
import org.graylog.security.shares.EntityShareResponse;
import org.graylog.security.shares.Grantee;
import org.graylog.security.shares.GranteeService;
import org.graylog2.plugin.database.users.User;
import org.graylog2.plugin.rest.ValidationResult;

public class EntitySharesService {
    private final DBGrantService grantService;
    private final EntityDependencyResolver entityDependencyResolver;
    private final EntityDependencyPermissionChecker entityDependencyPermissionChecker;
    private final GRNRegistry grnRegistry;
    private final GranteeService granteeService;
    private final EventBus serverEventBus;

    @Inject
    public EntitySharesService(DBGrantService grantService, EntityDependencyResolver entityDependencyResolver, EntityDependencyPermissionChecker entityDependencyPermissionChecker, GRNRegistry grnRegistry, GranteeService granteeService, EventBus serverEventBus) {
        this.grantService = grantService;
        this.entityDependencyResolver = entityDependencyResolver;
        this.entityDependencyPermissionChecker = entityDependencyPermissionChecker;
        this.grnRegistry = grnRegistry;
        this.granteeService = granteeService;
        this.serverEventBus = serverEventBus;
    }

    public EntityShareResponse prepareShare(GRN ownedEntity, EntityShareRequest request, User sharingUser, Subject sharingSubject) {
        Objects.requireNonNull(ownedEntity, "ownedEntity cannot be null");
        Objects.requireNonNull(request, "request cannot be null");
        Objects.requireNonNull(sharingUser, "sharingUser cannot be null");
        Objects.requireNonNull(sharingSubject, "sharingSubject cannot be null");
        GRN sharingUserGRN = this.grnRegistry.ofUser(sharingUser);
        Set<Grantee> availableGrantees = this.granteeService.getAvailableGrantees(sharingUser);
        Set<GRN> availableGranteeGRNs = availableGrantees.stream().map(Grantee::grn).collect(Collectors.toSet());
        ImmutableSet<EntityShareResponse.ActiveShare> activeShares = this.getActiveShares(ownedEntity, sharingUser, availableGranteeGRNs);
        return EntityShareResponse.builder().entity(ownedEntity.toString()).sharingUser(sharingUserGRN).availableGrantees(availableGrantees).availableCapabilities((Set<EntityShareResponse.AvailableCapability>)this.getAvailableCapabilities()).activeShares((Set<EntityShareResponse.ActiveShare>)activeShares).selectedGranteeCapabilities(this.getSelectedGranteeCapabilities(activeShares, request)).missingPermissionsOnDependencies((Map<GRN, Collection<EntityDescriptor>>)this.checkMissingPermissionsOnDependencies(ownedEntity, sharingUserGRN, activeShares, request)).validationResult(this.validateRequest(ownedEntity, request, sharingUser, availableGranteeGRNs)).build();
    }

    public EntityShareResponse updateEntityShares(GRN ownedEntity, EntityShareRequest request, User sharingUser) {
        Objects.requireNonNull(ownedEntity, "ownedEntity cannot be null");
        Objects.requireNonNull(request, "request cannot be null");
        Objects.requireNonNull(sharingUser, "sharingUser cannot be null");
        ImmutableMap<GRN, Capability> selectedGranteeCapabilities = request.selectedGranteeCapabilities().orElse((ImmutableMap<GRN, Capability>)ImmutableMap.of());
        String userName = sharingUser.getName();
        GRN sharingUserGRN = this.grnRegistry.ofUser(sharingUser);
        Set<Grantee> availableGrantees = this.granteeService.getAvailableGrantees(sharingUser);
        Set<GRN> availableGranteeGRNs = availableGrantees.stream().map(Grantee::grn).collect(Collectors.toSet());
        List<GrantDTO> existingGrants = this.grantService.getForTargetExcludingGrantee(ownedEntity, sharingUserGRN);
        existingGrants.removeIf(grant -> !availableGranteeGRNs.contains(grant.grantee()));
        EntityShareResponse.Builder responseBuilder = EntityShareResponse.builder().entity(ownedEntity.toString()).sharingUser(sharingUserGRN).availableGrantees(availableGrantees).availableCapabilities((Set<EntityShareResponse.AvailableCapability>)this.getAvailableCapabilities()).missingPermissionsOnDependencies((Map<GRN, Collection<EntityDescriptor>>)this.checkMissingPermissionsOnDependencies(ownedEntity, sharingUserGRN, (ImmutableSet<EntityShareResponse.ActiveShare>)ImmutableSet.of(), request));
        EntitySharesUpdateEvent.Builder updateEventBuilder = EntitySharesUpdateEvent.builder().user(sharingUser).entity(ownedEntity);
        ValidationResult validationResult = this.validateRequest(ownedEntity, request, sharingUser, availableGranteeGRNs);
        if (validationResult.failed()) {
            ImmutableSet<EntityShareResponse.ActiveShare> activeShares = this.getActiveShares(ownedEntity, sharingUser, availableGranteeGRNs);
            return responseBuilder.activeShares((Set<EntityShareResponse.ActiveShare>)activeShares).selectedGranteeCapabilities(this.getSelectedGranteeCapabilities(activeShares, request)).validationResult(validationResult).build();
        }
        existingGrants.stream().filter(grantDTO -> request.grantees().contains(grantDTO.grantee())).forEach(g -> {
            Capability newCapability = (Capability)((Object)((Object)selectedGranteeCapabilities.get((Object)g.grantee())));
            if (!g.capability().equals((Object)newCapability)) {
                this.grantService.save(g.toBuilder().capability(newCapability).updatedBy(userName).updatedAt(ZonedDateTime.now(ZoneOffset.UTC)).build());
                updateEventBuilder.addUpdates(g.grantee(), newCapability, g.capability());
            }
        });
        selectedGranteeCapabilities.forEach((grantee, capability) -> {
            if (existingGrants.stream().noneMatch(eg -> eg.grantee().equals(grantee))) {
                this.grantService.create(GrantDTO.builder().grantee((GRN)grantee).capability((Capability)((Object)capability)).target(ownedEntity).build(), sharingUser);
                updateEventBuilder.addCreates((GRN)grantee, (Capability)((Object)capability));
            }
        });
        existingGrants.forEach(g -> {
            if (!selectedGranteeCapabilities.containsKey((Object)g.grantee())) {
                this.grantService.delete(g.id());
                updateEventBuilder.addDeletes(g.grantee(), g.capability());
            }
        });
        this.postUpdateEvent(updateEventBuilder.build());
        ImmutableSet<EntityShareResponse.ActiveShare> activeShares = this.getActiveShares(ownedEntity, sharingUser, availableGranteeGRNs);
        return responseBuilder.activeShares((Set<EntityShareResponse.ActiveShare>)activeShares).selectedGranteeCapabilities(this.getSelectedGranteeCapabilities(activeShares, request)).build();
    }

    private void postUpdateEvent(EntitySharesUpdateEvent updateEvent) {
        this.serverEventBus.post((Object)updateEvent);
    }

    private ValidationResult validateRequest(GRN ownedEntity, EntityShareRequest request, User sharingUser, Set<GRN> availableGranteeGRNs) {
        ValidationResult validationResult = new ValidationResult();
        List<GrantDTO> allEntityGrants = this.grantService.getForTarget(ownedEntity);
        List<GrantDTO> existingGrants = this.grantService.getForTargetExcludingGrantee(ownedEntity, this.grnRegistry.ofUser(sharingUser));
        if (!request.selectedGranteeCapabilities().isPresent()) {
            return validationResult;
        }
        ImmutableMap<GRN, Capability> selectedGranteeCapabilities = request.selectedGranteeCapabilities().get();
        if (selectedGranteeCapabilities.containsValue((Object)Capability.OWN)) {
            return validationResult;
        }
        if (allEntityGrants.stream().noneMatch(g -> g.capability().equals((Object)Capability.OWN))) {
            return validationResult;
        }
        ArrayList removedOwners = new ArrayList();
        existingGrants.stream().filter(g -> g.capability().equals((Object)Capability.OWN)).forEach(g -> {
            if (!selectedGranteeCapabilities.containsKey((Object)g.grantee())) {
                if (availableGranteeGRNs.contains(g.grantee())) {
                    removedOwners.add(g.grantee());
                }
            } else if (!((Capability)((Object)((Object)selectedGranteeCapabilities.get((Object)g.grantee())))).equals((Object)Capability.OWN)) {
                removedOwners.add(g.grantee());
            }
        });
        if (allEntityGrants.stream().filter(g -> g.capability().equals((Object)Capability.OWN)).map(GrantDTO::grantee).anyMatch(grantee -> !removedOwners.contains(grantee))) {
            return validationResult;
        }
        validationResult.addError("selected_grantee_capabilities", String.format(Locale.US, "Removing the following owners <%s> will leave the entity ownerless.", removedOwners));
        validationResult.addContext("selected_grantee_capabilities", removedOwners.stream().map(Objects::toString).collect(Collectors.toSet()));
        return validationResult;
    }

    private Map<GRN, Capability> getSelectedGranteeCapabilities(ImmutableSet<EntityShareResponse.ActiveShare> activeShares, EntityShareRequest shareRequest) {
        if (!shareRequest.selectedGranteeCapabilities().isPresent()) {
            return activeShares.stream().collect(Collectors.toMap(EntityShareResponse.ActiveShare::grantee, EntityShareResponse.ActiveShare::capability));
        }
        return (Map)shareRequest.selectedGranteeCapabilities().get();
    }

    private ImmutableSet<EntityShareResponse.ActiveShare> getActiveShares(GRN ownedEntity, User sharingUser, Set<GRN> avialableGranteeGRNs) {
        List<GrantDTO> activeGrants = this.grantService.getForTargetExcludingGrantee(ownedEntity, this.grnRegistry.ofUser(sharingUser));
        return (ImmutableSet)activeGrants.stream().filter(grant -> avialableGranteeGRNs.contains(grant.grantee())).map(grant -> EntityShareResponse.ActiveShare.create(this.grnRegistry.newGRN("grant", grant.id()).toString(), grant.grantee(), grant.capability())).collect(ImmutableSet.toImmutableSet());
    }

    private ImmutableSet<EntityShareResponse.AvailableCapability> getAvailableCapabilities() {
        return (ImmutableSet)BuiltinCapabilities.allSharingCapabilities().stream().map(descriptor -> EntityShareResponse.AvailableCapability.create(descriptor.capability().toId(), descriptor.title())).collect(ImmutableSet.toImmutableSet());
    }

    private ImmutableMap<GRN, Collection<EntityDescriptor>> checkMissingPermissionsOnDependencies(GRN entity, GRN sharingUser, ImmutableSet<EntityShareResponse.ActiveShare> activeShares, EntityShareRequest shareRequest) {
        Object selectedGrantees = !shareRequest.selectedGranteeCapabilities().isPresent() ? activeShares.stream().map(EntityShareResponse.ActiveShare::grantee).collect(Collectors.toSet()) : shareRequest.selectedGranteeCapabilities().orElse((ImmutableMap<GRN, Capability>)ImmutableMap.of()).keySet();
        ImmutableSet<EntityDescriptor> dependencies = this.entityDependencyResolver.resolve(entity);
        return this.entityDependencyPermissionChecker.check(sharingUser, dependencies, (Set<GRN>)selectedGrantees).asMap();
    }
}

