/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;

public final class MongoZonedDateTimeSerializer
extends StdScalarSerializer<ZonedDateTime> {
    public MongoZonedDateTimeSerializer() {
        super(ZonedDateTime.class);
    }

    public void serialize(ZonedDateTime zonedDateTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        Instant instant = zonedDateTime.withZoneSameInstant(ZoneOffset.UTC).toInstant();
        Date date = Date.from(instant);
        jsonGenerator.writeObject((Object)date);
    }
}

