/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.utilities.date;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import org.graylog2.plugin.Tools;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class DateTimeConverter {
    public static DateTime convertToDateTime(@Nonnull Object value) {
        if (value instanceof DateTime) {
            return (DateTime)value;
        }
        if (value instanceof Date) {
            return new DateTime(value, DateTimeZone.UTC);
        }
        if (value instanceof ZonedDateTime) {
            DateTimeZone dateTimeZone = DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(((ZonedDateTime)value).getZone()));
            return new DateTime((Object)Date.from(((ZonedDateTime)value).toInstant()), dateTimeZone);
        }
        if (value instanceof OffsetDateTime) {
            return new DateTime((Object)Date.from(((OffsetDateTime)value).toInstant()), DateTimeZone.UTC);
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)value;
            ZoneId defaultZoneId = ZoneId.systemDefault();
            ZoneOffset offset = defaultZoneId.getRules().getOffset(localDateTime);
            return new DateTime((Object)Date.from(localDateTime.toInstant(offset)));
        }
        if (value instanceof LocalDate) {
            LocalDate localDate = (LocalDate)value;
            LocalDateTime localDateTime = localDate.atStartOfDay();
            ZoneId defaultZoneId = ZoneId.systemDefault();
            ZoneOffset offset = defaultZoneId.getRules().getOffset(localDateTime);
            return new DateTime((Object)Date.from(localDateTime.toInstant(offset)));
        }
        if (value instanceof Instant) {
            return new DateTime((Object)Date.from((Instant)value), DateTimeZone.UTC);
        }
        if (value instanceof String) {
            return Tools.ES_DATE_FORMAT_FORMATTER.parseDateTime((String)value);
        }
        throw new IllegalArgumentException("Value of invalid type <" + value.getClass().getSimpleName() + "> provided");
    }
}

