/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Timer;
import com.codahale.metrics.UniformReservoir;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.graylog.plugins.map.config.GeoIpResolverConfig;
import org.graylog.plugins.map.geoip.GeoAsnInformation;
import org.graylog.plugins.map.geoip.GeoIpResolver;
import org.graylog.plugins.map.geoip.GeoIpVendorResolverService;
import org.graylog.plugins.map.geoip.GeoLocationInformation;
import org.graylog2.plugin.validate.ClusterConfigValidator;
import org.graylog2.plugin.validate.ConfigValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoIpResolverConfigValidator
implements ClusterConfigValidator {
    private static final Logger LOG = LoggerFactory.getLogger(GeoIpResolverConfigValidator.class);
    private static final List<TimeUnit> VALID_UNITS = Arrays.asList(TimeUnit.SECONDS, TimeUnit.MINUTES, TimeUnit.HOURS, TimeUnit.DAYS);
    private final GeoIpVendorResolverService geoIpVendorResolverService;

    @Inject
    public GeoIpResolverConfigValidator(GeoIpVendorResolverService geoIpVendorResolverService) {
        this.geoIpVendorResolverService = geoIpVendorResolverService;
    }

    @Override
    public void validate(Object configObject) throws ConfigValidationException {
        if (configObject instanceof GeoIpResolverConfig) {
            GeoIpResolverConfig config = (GeoIpResolverConfig)configObject;
            if (config.enabled()) {
                this.validateConfig(config);
            } else {
                LOG.debug("'{}' is disabled.  Skipping validation", (Object)config);
            }
        } else {
            LOG.warn("'{}' cannot be validated with '{}'.  Validator may have been registered incorrectly.", configObject, this.getClass());
        }
    }

    private void validateConfig(GeoIpResolverConfig config) throws ConfigValidationException {
        Timer timer = new Timer((Reservoir)new UniformReservoir());
        try {
            if (!VALID_UNITS.contains((Object)config.refreshIntervalUnit())) {
                String valid = VALID_UNITS.stream().map(Enum::name).collect(Collectors.joining(","));
                String error = String.format(Locale.ENGLISH, "Invalid '%s'. Valid units are '%s'", "refresh_interval_unit", valid);
                throw new IllegalArgumentException(error);
            }
            InetAddress testAddress = InetAddress.getByName("127.0.0.1");
            this.validateGeoIpLocationResolver(config, timer, testAddress);
            this.validateGeoIpAsnResolver(config, timer, testAddress);
        }
        catch (IllegalArgumentException | IllegalStateException | UnknownHostException e) {
            throw new ConfigValidationException(e.getMessage());
        }
    }

    private void validateGeoIpAsnResolver(GeoIpResolverConfig config, Timer timer, InetAddress testAddress) {
        if (config.enabled() && StringUtils.isNotBlank((CharSequence)config.asnDbPath())) {
            GeoIpResolver<GeoAsnInformation> asnResolver = this.geoIpVendorResolverService.createAsnResolver(config, timer);
            if (config.enabled() && !asnResolver.isEnabled()) {
                String msg = String.format(Locale.ENGLISH, "Invalid '%s'  ASN database file '%s'.  Make sure the file exists and is valid for '%1$s'", new Object[]{config.databaseVendorType(), config.asnDbPath()});
                throw new IllegalArgumentException(msg);
            }
            asnResolver.getGeoIpData(testAddress);
            if (asnResolver.getLastError().isPresent()) {
                String error = String.format(Locale.ENGLISH, "Error querying ASN.  Make sure you have selected a valid ASN database type for '%s'", new Object[]{config.databaseVendorType()});
                throw new IllegalStateException(error);
            }
        }
    }

    private void validateGeoIpLocationResolver(GeoIpResolverConfig config, Timer timer, InetAddress testAddress) {
        GeoIpResolver<GeoLocationInformation> cityResolver = this.geoIpVendorResolverService.createCityResolver(config, timer);
        if (config.enabled() && !cityResolver.isEnabled()) {
            String msg = String.format(Locale.ENGLISH, "Invalid '%s' City Geo IP database file '%s'.  Make sure the file exists and is valid for '%1$s'", new Object[]{config.databaseVendorType(), config.cityDbPath()});
            throw new IllegalArgumentException(msg);
        }
        cityResolver.getGeoIpData(testAddress);
        if (cityResolver.getLastError().isPresent()) {
            String error = String.format(Locale.ENGLISH, "Error querying Geo Location.  Make sure you have selected a valid database type for '%s'", new Object[]{config.databaseVendorType()});
            throw new IllegalStateException(error);
        }
    }
}

